package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{BooleanType, MarkerType}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListKeysResponse(
    keys: Optional[Iterable[zio.aws.kms.model.KeyListEntry]] = Optional.Absent,
    nextMarker: Optional[MarkerType] = Optional.Absent,
    truncated: Optional[BooleanType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.ListKeysResponse = {
    import ListKeysResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.ListKeysResponse
      .builder()
      .optionallyWith(
        keys.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.keys)
      .optionallyWith(
        nextMarker.map(value => MarkerType.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .optionallyWith(
        truncated.map(value => BooleanType.unwrap(value): java.lang.Boolean)
      )(_.truncated)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.ListKeysResponse.ReadOnly =
    zio.aws.kms.model.ListKeysResponse.wrap(buildAwsValue())
}
object ListKeysResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.ListKeysResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.ListKeysResponse =
      zio.aws.kms.model.ListKeysResponse(
        keys.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextMarker.map(value => value),
        truncated.map(value => value)
      )
    def keys: Optional[List[zio.aws.kms.model.KeyListEntry.ReadOnly]]
    def nextMarker: Optional[MarkerType]
    def truncated: Optional[BooleanType]
    def getKeys
        : ZIO[Any, AwsError, List[zio.aws.kms.model.KeyListEntry.ReadOnly]] =
      AwsError.unwrapOptionField("keys", keys)
    def getNextMarker: ZIO[Any, AwsError, MarkerType] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getTruncated: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("truncated", truncated)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.ListKeysResponse
  ) extends zio.aws.kms.model.ListKeysResponse.ReadOnly {
    override val keys: Optional[List[zio.aws.kms.model.KeyListEntry.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keys())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kms.model.KeyListEntry.wrap(item)
          }.toList
        )
    override val nextMarker: Optional[MarkerType] = zio.aws.core.internal
      .optionalFromNullable(impl.nextMarker())
      .map(value => zio.aws.kms.model.primitives.MarkerType(value))
    override val truncated: Optional[BooleanType] = zio.aws.core.internal
      .optionalFromNullable(impl.truncated())
      .map(value => zio.aws.kms.model.primitives.BooleanType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.ListKeysResponse
  ): zio.aws.kms.model.ListKeysResponse.ReadOnly = new Wrapper(impl)
}
