package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{BooleanType, MarkerType}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListAliasesResponse(
    aliases: Optional[Iterable[zio.aws.kms.model.AliasListEntry]] =
      Optional.Absent,
    nextMarker: Optional[MarkerType] = Optional.Absent,
    truncated: Optional[BooleanType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.ListAliasesResponse = {
    import ListAliasesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.ListAliasesResponse
      .builder()
      .optionallyWith(
        aliases.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.aliases)
      .optionallyWith(
        nextMarker.map(value => MarkerType.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .optionallyWith(
        truncated.map(value => BooleanType.unwrap(value): java.lang.Boolean)
      )(_.truncated)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.ListAliasesResponse.ReadOnly =
    zio.aws.kms.model.ListAliasesResponse.wrap(buildAwsValue())
}
object ListAliasesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.ListAliasesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.ListAliasesResponse =
      zio.aws.kms.model.ListAliasesResponse(
        aliases.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextMarker.map(value => value),
        truncated.map(value => value)
      )
    def aliases: Optional[List[zio.aws.kms.model.AliasListEntry.ReadOnly]]
    def nextMarker: Optional[MarkerType]
    def truncated: Optional[BooleanType]
    def getAliases
        : ZIO[Any, AwsError, List[zio.aws.kms.model.AliasListEntry.ReadOnly]] =
      AwsError.unwrapOptionField("aliases", aliases)
    def getNextMarker: ZIO[Any, AwsError, MarkerType] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getTruncated: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("truncated", truncated)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.ListAliasesResponse
  ) extends zio.aws.kms.model.ListAliasesResponse.ReadOnly {
    override val aliases
        : Optional[List[zio.aws.kms.model.AliasListEntry.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.aliases())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kms.model.AliasListEntry.wrap(item)
          }.toList
        )
    override val nextMarker: Optional[MarkerType] = zio.aws.core.internal
      .optionalFromNullable(impl.nextMarker())
      .map(value => zio.aws.kms.model.primitives.MarkerType(value))
    override val truncated: Optional[BooleanType] = zio.aws.core.internal
      .optionalFromNullable(impl.truncated())
      .map(value => zio.aws.kms.model.primitives.BooleanType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.ListAliasesResponse
  ): zio.aws.kms.model.ListAliasesResponse.ReadOnly = new Wrapper(impl)
}
