package zio.aws.kms.model
import scala.jdk.CollectionConverters.*
sealed trait KeyState {
  def unwrap: software.amazon.awssdk.services.kms.model.KeyState
}
object KeyState {
  def wrap(
      value: software.amazon.awssdk.services.kms.model.KeyState
  ): zio.aws.kms.model.KeyState = value match {
    case software.amazon.awssdk.services.kms.model.KeyState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kms.model.KeyState.CREATING =>
      val r = Creating
      r
    case software.amazon.awssdk.services.kms.model.KeyState.ENABLED =>
      val r = Enabled
      r
    case software.amazon.awssdk.services.kms.model.KeyState.DISABLED =>
      val r = Disabled
      r
    case software.amazon.awssdk.services.kms.model.KeyState.PENDING_DELETION =>
      val r = PendingDeletion
      r
    case software.amazon.awssdk.services.kms.model.KeyState.PENDING_IMPORT =>
      val r = PendingImport
      r
    case software.amazon.awssdk.services.kms.model.KeyState.PENDING_REPLICA_DELETION =>
      val r = PendingReplicaDeletion
      r
    case software.amazon.awssdk.services.kms.model.KeyState.UNAVAILABLE =>
      val r = Unavailable
      r
    case software.amazon.awssdk.services.kms.model.KeyState.UPDATING =>
      val r = Updating
      r
  }
  case object unknownToSdkVersion extends zio.aws.kms.model.KeyState {
    override def unwrap: software.amazon.awssdk.services.kms.model.KeyState =
      software.amazon.awssdk.services.kms.model.KeyState.UNKNOWN_TO_SDK_VERSION
  }
  case object Creating extends zio.aws.kms.model.KeyState {
    override def unwrap: software.amazon.awssdk.services.kms.model.KeyState =
      software.amazon.awssdk.services.kms.model.KeyState.CREATING
  }
  case object Enabled extends zio.aws.kms.model.KeyState {
    override def unwrap: software.amazon.awssdk.services.kms.model.KeyState =
      software.amazon.awssdk.services.kms.model.KeyState.ENABLED
  }
  case object Disabled extends zio.aws.kms.model.KeyState {
    override def unwrap: software.amazon.awssdk.services.kms.model.KeyState =
      software.amazon.awssdk.services.kms.model.KeyState.DISABLED
  }
  case object PendingDeletion extends zio.aws.kms.model.KeyState {
    override def unwrap: software.amazon.awssdk.services.kms.model.KeyState =
      software.amazon.awssdk.services.kms.model.KeyState.PENDING_DELETION
  }
  case object PendingImport extends zio.aws.kms.model.KeyState {
    override def unwrap: software.amazon.awssdk.services.kms.model.KeyState =
      software.amazon.awssdk.services.kms.model.KeyState.PENDING_IMPORT
  }
  case object PendingReplicaDeletion extends zio.aws.kms.model.KeyState {
    override def unwrap: software.amazon.awssdk.services.kms.model.KeyState =
      software.amazon.awssdk.services.kms.model.KeyState.PENDING_REPLICA_DELETION
  }
  case object Unavailable extends zio.aws.kms.model.KeyState {
    override def unwrap: software.amazon.awssdk.services.kms.model.KeyState =
      software.amazon.awssdk.services.kms.model.KeyState.UNAVAILABLE
  }
  case object Updating extends zio.aws.kms.model.KeyState {
    override def unwrap: software.amazon.awssdk.services.kms.model.KeyState =
      software.amazon.awssdk.services.kms.model.KeyState.UPDATING
  }
}
