package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{
  KeyIdType,
  PublicKeyType,
  PlaintextType,
  CiphertextType
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GenerateDataKeyPairResponse(
    privateKeyCiphertextBlob: Optional[CiphertextType] = Optional.Absent,
    privateKeyPlaintext: Optional[PlaintextType] = Optional.Absent,
    publicKey: Optional[PublicKeyType] = Optional.Absent,
    keyId: Optional[KeyIdType] = Optional.Absent,
    keyPairSpec: Optional[zio.aws.kms.model.DataKeyPairSpec] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.GenerateDataKeyPairResponse = {
    import GenerateDataKeyPairResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.GenerateDataKeyPairResponse
      .builder()
      .optionallyWith(
        privateKeyCiphertextBlob.map(value =>
          software.amazon.awssdk.core.SdkBytes.fromByteArrayUnsafe(
            value.toArray[Byte]
          )
        )
      )(_.privateKeyCiphertextBlob)
      .optionallyWith(
        privateKeyPlaintext.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.privateKeyPlaintext)
      .optionallyWith(
        publicKey.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.publicKey)
      .optionallyWith(
        keyId.map(value => KeyIdType.unwrap(value): java.lang.String)
      )(_.keyId)
      .optionallyWith(keyPairSpec.map(value => value.unwrap))(_.keyPairSpec)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.GenerateDataKeyPairResponse.ReadOnly =
    zio.aws.kms.model.GenerateDataKeyPairResponse.wrap(buildAwsValue())
}
object GenerateDataKeyPairResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.GenerateDataKeyPairResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.GenerateDataKeyPairResponse =
      zio.aws.kms.model.GenerateDataKeyPairResponse(
        privateKeyCiphertextBlob.map(value => value),
        privateKeyPlaintext.map(value => value),
        publicKey.map(value => value),
        keyId.map(value => value),
        keyPairSpec.map(value => value)
      )
    def privateKeyCiphertextBlob: Optional[CiphertextType]
    def privateKeyPlaintext: Optional[PlaintextType]
    def publicKey: Optional[PublicKeyType]
    def keyId: Optional[KeyIdType]
    def keyPairSpec: Optional[zio.aws.kms.model.DataKeyPairSpec]
    def getPrivateKeyCiphertextBlob: ZIO[Any, AwsError, CiphertextType] =
      AwsError.unwrapOptionField(
        "privateKeyCiphertextBlob",
        privateKeyCiphertextBlob
      )
    def getPrivateKeyPlaintext: ZIO[Any, AwsError, PlaintextType] =
      AwsError.unwrapOptionField("privateKeyPlaintext", privateKeyPlaintext)
    def getPublicKey: ZIO[Any, AwsError, PublicKeyType] =
      AwsError.unwrapOptionField("publicKey", publicKey)
    def getKeyId: ZIO[Any, AwsError, KeyIdType] =
      AwsError.unwrapOptionField("keyId", keyId)
    def getKeyPairSpec: ZIO[Any, AwsError, zio.aws.kms.model.DataKeyPairSpec] =
      AwsError.unwrapOptionField("keyPairSpec", keyPairSpec)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.GenerateDataKeyPairResponse
  ) extends zio.aws.kms.model.GenerateDataKeyPairResponse.ReadOnly {
    override val privateKeyCiphertextBlob: Optional[CiphertextType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.privateKeyCiphertextBlob())
        .map(value =>
          zio.aws.kms.model.primitives
            .CiphertextType(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
        )
    override val privateKeyPlaintext: Optional[PlaintextType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.privateKeyPlaintext())
        .map(value =>
          zio.aws.kms.model.primitives
            .PlaintextType(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
        )
    override val publicKey: Optional[PublicKeyType] = zio.aws.core.internal
      .optionalFromNullable(impl.publicKey())
      .map(value =>
        zio.aws.kms.model.primitives
          .PublicKeyType(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
    override val keyId: Optional[KeyIdType] = zio.aws.core.internal
      .optionalFromNullable(impl.keyId())
      .map(value => zio.aws.kms.model.primitives.KeyIdType(value))
    override val keyPairSpec: Optional[zio.aws.kms.model.DataKeyPairSpec] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keyPairSpec())
        .map(value => zio.aws.kms.model.DataKeyPairSpec.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.GenerateDataKeyPairResponse
  ): zio.aws.kms.model.GenerateDataKeyPairResponse.ReadOnly = new Wrapper(impl)
}
