package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{KeyIdType, CiphertextType}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class EncryptResponse(
    ciphertextBlob: Optional[CiphertextType] = Optional.Absent,
    keyId: Optional[KeyIdType] = Optional.Absent,
    encryptionAlgorithm: Optional[zio.aws.kms.model.EncryptionAlgorithmSpec] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.EncryptResponse = {
    import EncryptResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.EncryptResponse
      .builder()
      .optionallyWith(
        ciphertextBlob.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.ciphertextBlob)
      .optionallyWith(
        keyId.map(value => KeyIdType.unwrap(value): java.lang.String)
      )(_.keyId)
      .optionallyWith(encryptionAlgorithm.map(value => value.unwrap))(
        _.encryptionAlgorithm
      )
      .build()
  }
  def asReadOnly: zio.aws.kms.model.EncryptResponse.ReadOnly =
    zio.aws.kms.model.EncryptResponse.wrap(buildAwsValue())
}
object EncryptResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.EncryptResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.EncryptResponse =
      zio.aws.kms.model.EncryptResponse(
        ciphertextBlob.map(value => value),
        keyId.map(value => value),
        encryptionAlgorithm.map(value => value)
      )
    def ciphertextBlob: Optional[CiphertextType]
    def keyId: Optional[KeyIdType]
    def encryptionAlgorithm: Optional[zio.aws.kms.model.EncryptionAlgorithmSpec]
    def getCiphertextBlob: ZIO[Any, AwsError, CiphertextType] =
      AwsError.unwrapOptionField("ciphertextBlob", ciphertextBlob)
    def getKeyId: ZIO[Any, AwsError, KeyIdType] =
      AwsError.unwrapOptionField("keyId", keyId)
    def getEncryptionAlgorithm
        : ZIO[Any, AwsError, zio.aws.kms.model.EncryptionAlgorithmSpec] =
      AwsError.unwrapOptionField("encryptionAlgorithm", encryptionAlgorithm)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.EncryptResponse
  ) extends zio.aws.kms.model.EncryptResponse.ReadOnly {
    override val ciphertextBlob: Optional[CiphertextType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ciphertextBlob())
        .map(value =>
          zio.aws.kms.model.primitives
            .CiphertextType(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
        )
    override val keyId: Optional[KeyIdType] = zio.aws.core.internal
      .optionalFromNullable(impl.keyId())
      .map(value => zio.aws.kms.model.primitives.KeyIdType(value))
    override val encryptionAlgorithm
        : Optional[zio.aws.kms.model.EncryptionAlgorithmSpec] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionAlgorithm())
        .map(value => zio.aws.kms.model.EncryptionAlgorithmSpec.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.EncryptResponse
  ): zio.aws.kms.model.EncryptResponse.ReadOnly = new Wrapper(impl)
}
