package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.kms.model.primitives.CustomKeyStoreIdType
import scala.jdk.CollectionConverters.*
final case class DisconnectCustomKeyStoreRequest(
    customKeyStoreId: CustomKeyStoreIdType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.DisconnectCustomKeyStoreRequest = {
    import DisconnectCustomKeyStoreRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.DisconnectCustomKeyStoreRequest
      .builder()
      .customKeyStoreId(
        CustomKeyStoreIdType.unwrap(customKeyStoreId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.kms.model.DisconnectCustomKeyStoreRequest.ReadOnly =
    zio.aws.kms.model.DisconnectCustomKeyStoreRequest.wrap(buildAwsValue())
}
object DisconnectCustomKeyStoreRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.DisconnectCustomKeyStoreRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.DisconnectCustomKeyStoreRequest =
      zio.aws.kms.model.DisconnectCustomKeyStoreRequest(customKeyStoreId)
    def customKeyStoreId: CustomKeyStoreIdType
    def getCustomKeyStoreId: ZIO[Any, Nothing, CustomKeyStoreIdType] =
      ZIO.succeed(customKeyStoreId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.DisconnectCustomKeyStoreRequest
  ) extends zio.aws.kms.model.DisconnectCustomKeyStoreRequest.ReadOnly {
    override val customKeyStoreId: CustomKeyStoreIdType =
      zio.aws.kms.model.primitives.CustomKeyStoreIdType(impl.customKeyStoreId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.DisconnectCustomKeyStoreRequest
  ): zio.aws.kms.model.DisconnectCustomKeyStoreRequest.ReadOnly = new Wrapper(
    impl
  )
}
