package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.kms.model.primitives.KeyIdType
import scala.jdk.CollectionConverters.*
final case class DisableKeyRequest(keyId: KeyIdType) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.DisableKeyRequest = {
    import DisableKeyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.DisableKeyRequest
      .builder()
      .keyId(KeyIdType.unwrap(keyId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.DisableKeyRequest.ReadOnly =
    zio.aws.kms.model.DisableKeyRequest.wrap(buildAwsValue())
}
object DisableKeyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.DisableKeyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.DisableKeyRequest =
      zio.aws.kms.model.DisableKeyRequest(keyId)
    def keyId: KeyIdType
    def getKeyId: ZIO[Any, Nothing, KeyIdType] = ZIO.succeed(keyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.DisableKeyRequest
  ) extends zio.aws.kms.model.DisableKeyRequest.ReadOnly {
    override val keyId: KeyIdType =
      zio.aws.kms.model.primitives.KeyIdType(impl.keyId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.DisableKeyRequest
  ): zio.aws.kms.model.DisableKeyRequest.ReadOnly = new Wrapper(impl)
}
