package zio.aws.kms.model
import scala.jdk.CollectionConverters.*
sealed trait CustomerMasterKeySpec {
  def unwrap: software.amazon.awssdk.services.kms.model.CustomerMasterKeySpec
}
object CustomerMasterKeySpec {
  def wrap(
      value: software.amazon.awssdk.services.kms.model.CustomerMasterKeySpec
  ): zio.aws.kms.model.CustomerMasterKeySpec = value match {
    case software.amazon.awssdk.services.kms.model.CustomerMasterKeySpec.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kms.model.CustomerMasterKeySpec.RSA_2048 =>
      val r = RSA_2048
      r
    case software.amazon.awssdk.services.kms.model.CustomerMasterKeySpec.RSA_3072 =>
      val r = RSA_3072
      r
    case software.amazon.awssdk.services.kms.model.CustomerMasterKeySpec.RSA_4096 =>
      val r = RSA_4096
      r
    case software.amazon.awssdk.services.kms.model.CustomerMasterKeySpec.ECC_NIST_P256 =>
      val r = ECC_NIST_P256
      r
    case software.amazon.awssdk.services.kms.model.CustomerMasterKeySpec.ECC_NIST_P384 =>
      val r = ECC_NIST_P384
      r
    case software.amazon.awssdk.services.kms.model.CustomerMasterKeySpec.ECC_NIST_P521 =>
      val r = ECC_NIST_P521
      r
    case software.amazon.awssdk.services.kms.model.CustomerMasterKeySpec.ECC_SECG_P256_K1 =>
      val r = ECC_SECG_P256K1
      r
    case software.amazon.awssdk.services.kms.model.CustomerMasterKeySpec.SYMMETRIC_DEFAULT =>
      val r = SYMMETRIC_DEFAULT
      r
    case software.amazon.awssdk.services.kms.model.CustomerMasterKeySpec.HMAC_224 =>
      val r = HMAC_224
      r
    case software.amazon.awssdk.services.kms.model.CustomerMasterKeySpec.HMAC_256 =>
      val r = HMAC_256
      r
    case software.amazon.awssdk.services.kms.model.CustomerMasterKeySpec.HMAC_384 =>
      val r = HMAC_384
      r
    case software.amazon.awssdk.services.kms.model.CustomerMasterKeySpec.HMAC_512 =>
      val r = HMAC_512
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.kms.model.CustomerMasterKeySpec {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.CustomerMasterKeySpec =
      software.amazon.awssdk.services.kms.model.CustomerMasterKeySpec.UNKNOWN_TO_SDK_VERSION
  }
  case object RSA_2048 extends zio.aws.kms.model.CustomerMasterKeySpec {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.CustomerMasterKeySpec =
      software.amazon.awssdk.services.kms.model.CustomerMasterKeySpec.RSA_2048
  }
  case object RSA_3072 extends zio.aws.kms.model.CustomerMasterKeySpec {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.CustomerMasterKeySpec =
      software.amazon.awssdk.services.kms.model.CustomerMasterKeySpec.RSA_3072
  }
  case object RSA_4096 extends zio.aws.kms.model.CustomerMasterKeySpec {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.CustomerMasterKeySpec =
      software.amazon.awssdk.services.kms.model.CustomerMasterKeySpec.RSA_4096
  }
  case object ECC_NIST_P256 extends zio.aws.kms.model.CustomerMasterKeySpec {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.CustomerMasterKeySpec =
      software.amazon.awssdk.services.kms.model.CustomerMasterKeySpec.ECC_NIST_P256
  }
  case object ECC_NIST_P384 extends zio.aws.kms.model.CustomerMasterKeySpec {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.CustomerMasterKeySpec =
      software.amazon.awssdk.services.kms.model.CustomerMasterKeySpec.ECC_NIST_P384
  }
  case object ECC_NIST_P521 extends zio.aws.kms.model.CustomerMasterKeySpec {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.CustomerMasterKeySpec =
      software.amazon.awssdk.services.kms.model.CustomerMasterKeySpec.ECC_NIST_P521
  }
  case object ECC_SECG_P256K1 extends zio.aws.kms.model.CustomerMasterKeySpec {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.CustomerMasterKeySpec =
      software.amazon.awssdk.services.kms.model.CustomerMasterKeySpec.ECC_SECG_P256_K1
  }
  case object SYMMETRIC_DEFAULT
      extends zio.aws.kms.model.CustomerMasterKeySpec {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.CustomerMasterKeySpec =
      software.amazon.awssdk.services.kms.model.CustomerMasterKeySpec.SYMMETRIC_DEFAULT
  }
  case object HMAC_224 extends zio.aws.kms.model.CustomerMasterKeySpec {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.CustomerMasterKeySpec =
      software.amazon.awssdk.services.kms.model.CustomerMasterKeySpec.HMAC_224
  }
  case object HMAC_256 extends zio.aws.kms.model.CustomerMasterKeySpec {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.CustomerMasterKeySpec =
      software.amazon.awssdk.services.kms.model.CustomerMasterKeySpec.HMAC_256
  }
  case object HMAC_384 extends zio.aws.kms.model.CustomerMasterKeySpec {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.CustomerMasterKeySpec =
      software.amazon.awssdk.services.kms.model.CustomerMasterKeySpec.HMAC_384
  }
  case object HMAC_512 extends zio.aws.kms.model.CustomerMasterKeySpec {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.CustomerMasterKeySpec =
      software.amazon.awssdk.services.kms.model.CustomerMasterKeySpec.HMAC_512
  }
}
