package zio.aws.kms.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.kms.model.primitives.{
  DateType,
  TrustAnchorCertificateType,
  CustomKeyStoreNameType,
  CloudHsmClusterIdType,
  CustomKeyStoreIdType
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class CustomKeyStoresListEntry(
    customKeyStoreId: Optional[CustomKeyStoreIdType] = Optional.Absent,
    customKeyStoreName: Optional[CustomKeyStoreNameType] = Optional.Absent,
    cloudHsmClusterId: Optional[CloudHsmClusterIdType] = Optional.Absent,
    trustAnchorCertificate: Optional[TrustAnchorCertificateType] =
      Optional.Absent,
    connectionState: Optional[zio.aws.kms.model.ConnectionStateType] =
      Optional.Absent,
    connectionErrorCode: Optional[zio.aws.kms.model.ConnectionErrorCodeType] =
      Optional.Absent,
    creationDate: Optional[DateType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.CustomKeyStoresListEntry = {
    import CustomKeyStoresListEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.CustomKeyStoresListEntry
      .builder()
      .optionallyWith(
        customKeyStoreId.map(value =>
          CustomKeyStoreIdType.unwrap(value): java.lang.String
        )
      )(_.customKeyStoreId)
      .optionallyWith(
        customKeyStoreName.map(value =>
          CustomKeyStoreNameType.unwrap(value): java.lang.String
        )
      )(_.customKeyStoreName)
      .optionallyWith(
        cloudHsmClusterId.map(value =>
          CloudHsmClusterIdType.unwrap(value): java.lang.String
        )
      )(_.cloudHsmClusterId)
      .optionallyWith(
        trustAnchorCertificate.map(value =>
          TrustAnchorCertificateType.unwrap(value): java.lang.String
        )
      )(_.trustAnchorCertificate)
      .optionallyWith(connectionState.map(value => value.unwrap))(
        _.connectionState
      )
      .optionallyWith(connectionErrorCode.map(value => value.unwrap))(
        _.connectionErrorCode
      )
      .optionallyWith(
        creationDate.map(value => DateType.unwrap(value): Instant)
      )(_.creationDate)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.CustomKeyStoresListEntry.ReadOnly =
    zio.aws.kms.model.CustomKeyStoresListEntry.wrap(buildAwsValue())
}
object CustomKeyStoresListEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.CustomKeyStoresListEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.CustomKeyStoresListEntry =
      zio.aws.kms.model.CustomKeyStoresListEntry(
        customKeyStoreId.map(value => value),
        customKeyStoreName.map(value => value),
        cloudHsmClusterId.map(value => value),
        trustAnchorCertificate.map(value => value),
        connectionState.map(value => value),
        connectionErrorCode.map(value => value),
        creationDate.map(value => value)
      )
    def customKeyStoreId: Optional[CustomKeyStoreIdType]
    def customKeyStoreName: Optional[CustomKeyStoreNameType]
    def cloudHsmClusterId: Optional[CloudHsmClusterIdType]
    def trustAnchorCertificate: Optional[TrustAnchorCertificateType]
    def connectionState: Optional[zio.aws.kms.model.ConnectionStateType]
    def connectionErrorCode: Optional[zio.aws.kms.model.ConnectionErrorCodeType]
    def creationDate: Optional[DateType]
    def getCustomKeyStoreId: ZIO[Any, AwsError, CustomKeyStoreIdType] =
      AwsError.unwrapOptionField("customKeyStoreId", customKeyStoreId)
    def getCustomKeyStoreName: ZIO[Any, AwsError, CustomKeyStoreNameType] =
      AwsError.unwrapOptionField("customKeyStoreName", customKeyStoreName)
    def getCloudHsmClusterId: ZIO[Any, AwsError, CloudHsmClusterIdType] =
      AwsError.unwrapOptionField("cloudHsmClusterId", cloudHsmClusterId)
    def getTrustAnchorCertificate
        : ZIO[Any, AwsError, TrustAnchorCertificateType] = AwsError
      .unwrapOptionField("trustAnchorCertificate", trustAnchorCertificate)
    def getConnectionState
        : ZIO[Any, AwsError, zio.aws.kms.model.ConnectionStateType] =
      AwsError.unwrapOptionField("connectionState", connectionState)
    def getConnectionErrorCode
        : ZIO[Any, AwsError, zio.aws.kms.model.ConnectionErrorCodeType] =
      AwsError.unwrapOptionField("connectionErrorCode", connectionErrorCode)
    def getCreationDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("creationDate", creationDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.CustomKeyStoresListEntry
  ) extends zio.aws.kms.model.CustomKeyStoresListEntry.ReadOnly {
    override val customKeyStoreId: Optional[CustomKeyStoreIdType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customKeyStoreId())
        .map(value => zio.aws.kms.model.primitives.CustomKeyStoreIdType(value))
    override val customKeyStoreName: Optional[CustomKeyStoreNameType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customKeyStoreName())
        .map(value =>
          zio.aws.kms.model.primitives.CustomKeyStoreNameType(value)
        )
    override val cloudHsmClusterId: Optional[CloudHsmClusterIdType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudHsmClusterId())
        .map(value => zio.aws.kms.model.primitives.CloudHsmClusterIdType(value))
    override val trustAnchorCertificate: Optional[TrustAnchorCertificateType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trustAnchorCertificate())
        .map(value =>
          zio.aws.kms.model.primitives.TrustAnchorCertificateType(value)
        )
    override val connectionState
        : Optional[zio.aws.kms.model.ConnectionStateType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectionState())
        .map(value => zio.aws.kms.model.ConnectionStateType.wrap(value))
    override val connectionErrorCode
        : Optional[zio.aws.kms.model.ConnectionErrorCodeType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectionErrorCode())
        .map(value => zio.aws.kms.model.ConnectionErrorCodeType.wrap(value))
    override val creationDate: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => zio.aws.kms.model.primitives.DateType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.CustomKeyStoresListEntry
  ): zio.aws.kms.model.CustomKeyStoresListEntry.ReadOnly = new Wrapper(impl)
}
