package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{GrantIdType, GrantTokenType}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateGrantResponse(
    grantToken: Optional[GrantTokenType] = Optional.Absent,
    grantId: Optional[GrantIdType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.CreateGrantResponse = {
    import CreateGrantResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.CreateGrantResponse
      .builder()
      .optionallyWith(
        grantToken.map(value => GrantTokenType.unwrap(value): java.lang.String)
      )(_.grantToken)
      .optionallyWith(
        grantId.map(value => GrantIdType.unwrap(value): java.lang.String)
      )(_.grantId)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.CreateGrantResponse.ReadOnly =
    zio.aws.kms.model.CreateGrantResponse.wrap(buildAwsValue())
}
object CreateGrantResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.CreateGrantResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.CreateGrantResponse =
      zio.aws.kms.model.CreateGrantResponse(
        grantToken.map(value => value),
        grantId.map(value => value)
      )
    def grantToken: Optional[GrantTokenType]
    def grantId: Optional[GrantIdType]
    def getGrantToken: ZIO[Any, AwsError, GrantTokenType] =
      AwsError.unwrapOptionField("grantToken", grantToken)
    def getGrantId: ZIO[Any, AwsError, GrantIdType] =
      AwsError.unwrapOptionField("grantId", grantId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.CreateGrantResponse
  ) extends zio.aws.kms.model.CreateGrantResponse.ReadOnly {
    override val grantToken: Optional[GrantTokenType] = zio.aws.core.internal
      .optionalFromNullable(impl.grantToken())
      .map(value => zio.aws.kms.model.primitives.GrantTokenType(value))
    override val grantId: Optional[GrantIdType] = zio.aws.core.internal
      .optionalFromNullable(impl.grantId())
      .map(value => zio.aws.kms.model.primitives.GrantIdType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.CreateGrantResponse
  ): zio.aws.kms.model.CreateGrantResponse.ReadOnly = new Wrapper(impl)
}
