package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.KeyIdType
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CancelKeyDeletionResponse(
    keyId: Optional[KeyIdType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.CancelKeyDeletionResponse = {
    import CancelKeyDeletionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.CancelKeyDeletionResponse
      .builder()
      .optionallyWith(
        keyId.map(value => KeyIdType.unwrap(value): java.lang.String)
      )(_.keyId)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.CancelKeyDeletionResponse.ReadOnly =
    zio.aws.kms.model.CancelKeyDeletionResponse.wrap(buildAwsValue())
}
object CancelKeyDeletionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.CancelKeyDeletionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.CancelKeyDeletionResponse =
      zio.aws.kms.model.CancelKeyDeletionResponse(keyId.map(value => value))
    def keyId: Optional[KeyIdType]
    def getKeyId: ZIO[Any, AwsError, KeyIdType] =
      AwsError.unwrapOptionField("keyId", keyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.CancelKeyDeletionResponse
  ) extends zio.aws.kms.model.CancelKeyDeletionResponse.ReadOnly {
    override val keyId: Optional[KeyIdType] = zio.aws.core.internal
      .optionalFromNullable(impl.keyId())
      .map(value => zio.aws.kms.model.primitives.KeyIdType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.CancelKeyDeletionResponse
  ): zio.aws.kms.model.CancelKeyDeletionResponse.ReadOnly = new Wrapper(impl)
}
