package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.kms.model.primitives.{TagValueType, TagKeyType}
import scala.jdk.CollectionConverters.*
final case class Tag(tagKey: TagKeyType, tagValue: TagValueType) {
  def buildAwsValue(): software.amazon.awssdk.services.kms.model.Tag = {
    import Tag.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.Tag
      .builder()
      .tagKey(TagKeyType.unwrap(tagKey): java.lang.String)
      .tagValue(TagValueType.unwrap(tagValue): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.Tag.ReadOnly =
    zio.aws.kms.model.Tag.wrap(buildAwsValue())
}
object Tag {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.kms.model.Tag] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.Tag =
      zio.aws.kms.model.Tag(tagKey, tagValue)
    def tagKey: TagKeyType
    def tagValue: TagValueType
    def getTagKey: ZIO[Any, Nothing, TagKeyType] = ZIO.succeed(tagKey)
    def getTagValue: ZIO[Any, Nothing, TagValueType] = ZIO.succeed(tagValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.Tag
  ) extends zio.aws.kms.model.Tag.ReadOnly {
    override val tagKey: TagKeyType =
      zio.aws.kms.model.primitives.TagKeyType(impl.tagKey())
    override val tagValue: TagValueType =
      zio.aws.kms.model.primitives.TagValueType(impl.tagValue())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.Tag
  ): zio.aws.kms.model.Tag.ReadOnly = new Wrapper(impl)
}
