package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{GrantTokenType, PlaintextType, KeyIdType}
import scala.jdk.CollectionConverters.*
final case class SignRequest(
    keyId: KeyIdType,
    message: PlaintextType,
    messageType: Option[zio.aws.kms.model.MessageType] = None,
    grantTokens: Option[Iterable[GrantTokenType]] = None,
    signingAlgorithm: zio.aws.kms.model.SigningAlgorithmSpec
) {
  def buildAwsValue(): software.amazon.awssdk.services.kms.model.SignRequest = {
    import SignRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.SignRequest
      .builder()
      .keyId(KeyIdType.unwrap(keyId): java.lang.String)
      .message(
        software.amazon.awssdk.core.SdkBytes
          .fromByteArrayUnsafe(message.toArray[Byte])
      )
      .optionallyWith(messageType.map(value => value.unwrap))(_.messageType)
      .optionallyWith(
        grantTokens.map(value =>
          value.map { item =>
            GrantTokenType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.grantTokens)
      .signingAlgorithm(signingAlgorithm.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.SignRequest.ReadOnly =
    zio.aws.kms.model.SignRequest.wrap(buildAwsValue())
}
object SignRequest {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.kms.model.SignRequest] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.SignRequest =
      zio.aws.kms.model.SignRequest(
        keyId,
        message,
        messageType.map(value => value),
        grantTokens.map(value => value),
        signingAlgorithm
      )
    def keyId: KeyIdType
    def message: PlaintextType
    def messageType: Option[zio.aws.kms.model.MessageType]
    def grantTokens: Option[List[GrantTokenType]]
    def signingAlgorithm: zio.aws.kms.model.SigningAlgorithmSpec
    def getKeyId: ZIO[Any, Nothing, KeyIdType] = ZIO.succeed(keyId)
    def getMessage: ZIO[Any, Nothing, PlaintextType] = ZIO.succeed(message)
    def getMessageType: ZIO[Any, AwsError, zio.aws.kms.model.MessageType] =
      AwsError.unwrapOptionField("messageType", messageType)
    def getGrantTokens: ZIO[Any, AwsError, List[GrantTokenType]] =
      AwsError.unwrapOptionField("grantTokens", grantTokens)
    def getSigningAlgorithm
        : ZIO[Any, Nothing, zio.aws.kms.model.SigningAlgorithmSpec] =
      ZIO.succeed(signingAlgorithm)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.SignRequest
  ) extends zio.aws.kms.model.SignRequest.ReadOnly {
    override val keyId: KeyIdType =
      zio.aws.kms.model.primitives.KeyIdType(impl.keyId())
    override val message: PlaintextType = zio.aws.kms.model.primitives
      .PlaintextType(zio.Chunk.fromArray(impl.message().asByteArrayUnsafe()))
    override val messageType: Option[zio.aws.kms.model.MessageType] = scala
      .Option(impl.messageType())
      .map(value => zio.aws.kms.model.MessageType.wrap(value))
    override val grantTokens: Option[List[GrantTokenType]] = scala
      .Option(impl.grantTokens())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kms.model.primitives.GrantTokenType(item)
        }.toList
      )
    override val signingAlgorithm: zio.aws.kms.model.SigningAlgorithmSpec =
      zio.aws.kms.model.SigningAlgorithmSpec.wrap(impl.signingAlgorithm())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.SignRequest
  ): zio.aws.kms.model.SignRequest.ReadOnly = new Wrapper(impl)
}
