package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.PolicyType
import scala.jdk.CollectionConverters.*
final case class ReplicateKeyResponse(
    replicaKeyMetadata: Option[zio.aws.kms.model.KeyMetadata] = None,
    replicaPolicy: Option[PolicyType] = None,
    replicaTags: Option[Iterable[zio.aws.kms.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.ReplicateKeyResponse = {
    import ReplicateKeyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.ReplicateKeyResponse
      .builder()
      .optionallyWith(replicaKeyMetadata.map(value => value.buildAwsValue()))(
        _.replicaKeyMetadata
      )
      .optionallyWith(
        replicaPolicy.map(value => PolicyType.unwrap(value): java.lang.String)
      )(_.replicaPolicy)
      .optionallyWith(
        replicaTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.replicaTags)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.ReplicateKeyResponse.ReadOnly =
    zio.aws.kms.model.ReplicateKeyResponse.wrap(buildAwsValue())
}
object ReplicateKeyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.ReplicateKeyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.ReplicateKeyResponse =
      zio.aws.kms.model.ReplicateKeyResponse(
        replicaKeyMetadata.map(value => value.asEditable),
        replicaPolicy.map(value => value),
        replicaTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def replicaKeyMetadata: Option[zio.aws.kms.model.KeyMetadata.ReadOnly]
    def replicaPolicy: Option[PolicyType]
    def replicaTags: Option[List[zio.aws.kms.model.Tag.ReadOnly]]
    def getReplicaKeyMetadata
        : ZIO[Any, AwsError, zio.aws.kms.model.KeyMetadata.ReadOnly] =
      AwsError.unwrapOptionField("replicaKeyMetadata", replicaKeyMetadata)
    def getReplicaPolicy: ZIO[Any, AwsError, PolicyType] =
      AwsError.unwrapOptionField("replicaPolicy", replicaPolicy)
    def getReplicaTags
        : ZIO[Any, AwsError, List[zio.aws.kms.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("replicaTags", replicaTags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.ReplicateKeyResponse
  ) extends zio.aws.kms.model.ReplicateKeyResponse.ReadOnly {
    override val replicaKeyMetadata
        : Option[zio.aws.kms.model.KeyMetadata.ReadOnly] = scala
      .Option(impl.replicaKeyMetadata())
      .map(value => zio.aws.kms.model.KeyMetadata.wrap(value))
    override val replicaPolicy: Option[PolicyType] = scala
      .Option(impl.replicaPolicy())
      .map(value => zio.aws.kms.model.primitives.PolicyType(value))
    override val replicaTags: Option[List[zio.aws.kms.model.Tag.ReadOnly]] =
      scala
        .Option(impl.replicaTags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kms.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.ReplicateKeyResponse
  ): zio.aws.kms.model.ReplicateKeyResponse.ReadOnly = new Wrapper(impl)
}
