package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{BooleanType, MarkerType}
import scala.jdk.CollectionConverters.*
final case class ListKeysResponse(
    keys: Option[Iterable[zio.aws.kms.model.KeyListEntry]] = None,
    nextMarker: Option[MarkerType] = None,
    truncated: Option[BooleanType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.ListKeysResponse = {
    import ListKeysResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.ListKeysResponse
      .builder()
      .optionallyWith(
        keys.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.keys)
      .optionallyWith(
        nextMarker.map(value => MarkerType.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .optionallyWith(
        truncated.map(value => BooleanType.unwrap(value): java.lang.Boolean)
      )(_.truncated)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.ListKeysResponse.ReadOnly =
    zio.aws.kms.model.ListKeysResponse.wrap(buildAwsValue())
}
object ListKeysResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.ListKeysResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.ListKeysResponse =
      zio.aws.kms.model.ListKeysResponse(
        keys.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextMarker.map(value => value),
        truncated.map(value => value)
      )
    def keys: Option[List[zio.aws.kms.model.KeyListEntry.ReadOnly]]
    def nextMarker: Option[MarkerType]
    def truncated: Option[BooleanType]
    def getKeys
        : ZIO[Any, AwsError, List[zio.aws.kms.model.KeyListEntry.ReadOnly]] =
      AwsError.unwrapOptionField("keys", keys)
    def getNextMarker: ZIO[Any, AwsError, MarkerType] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getTruncated: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("truncated", truncated)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.ListKeysResponse
  ) extends zio.aws.kms.model.ListKeysResponse.ReadOnly {
    override val keys: Option[List[zio.aws.kms.model.KeyListEntry.ReadOnly]] =
      scala
        .Option(impl.keys())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kms.model.KeyListEntry.wrap(item)
          }.toList
        )
    override val nextMarker: Option[MarkerType] = scala
      .Option(impl.nextMarker())
      .map(value => zio.aws.kms.model.primitives.MarkerType(value))
    override val truncated: Option[BooleanType] = scala
      .Option(impl.truncated())
      .map(value => zio.aws.kms.model.primitives.BooleanType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.ListKeysResponse
  ): zio.aws.kms.model.ListKeysResponse.ReadOnly = new Wrapper(impl)
}
