package zio.aws.kms.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{MarkerType, LimitType, KeyIdType}
import scala.jdk.CollectionConverters.*
final case class ListAliasesRequest(
    keyId: Option[KeyIdType] = None,
    limit: Option[LimitType] = None,
    marker: Option[MarkerType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.ListAliasesRequest = {
    import ListAliasesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.ListAliasesRequest
      .builder()
      .optionallyWith(
        keyId.map(value => KeyIdType.unwrap(value): java.lang.String)
      )(_.keyId)
      .optionallyWith(limit.map(value => LimitType.unwrap(value): Integer))(
        _.limit
      )
      .optionallyWith(
        marker.map(value => MarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.ListAliasesRequest.ReadOnly =
    zio.aws.kms.model.ListAliasesRequest.wrap(buildAwsValue())
}
object ListAliasesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.ListAliasesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.ListAliasesRequest =
      zio.aws.kms.model.ListAliasesRequest(
        keyId.map(value => value),
        limit.map(value => value),
        marker.map(value => value)
      )
    def keyId: Option[KeyIdType]
    def limit: Option[LimitType]
    def marker: Option[MarkerType]
    def getKeyId: ZIO[Any, AwsError, KeyIdType] =
      AwsError.unwrapOptionField("keyId", keyId)
    def getLimit: ZIO[Any, AwsError, LimitType] =
      AwsError.unwrapOptionField("limit", limit)
    def getMarker: ZIO[Any, AwsError, MarkerType] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.ListAliasesRequest
  ) extends zio.aws.kms.model.ListAliasesRequest.ReadOnly {
    override val keyId: Option[KeyIdType] = scala
      .Option(impl.keyId())
      .map(value => zio.aws.kms.model.primitives.KeyIdType(value))
    override val limit: Option[LimitType] = scala
      .Option(impl.limit())
      .map(value => zio.aws.kms.model.primitives.LimitType(value))
    override val marker: Option[MarkerType] = scala
      .Option(impl.marker())
      .map(value => zio.aws.kms.model.primitives.MarkerType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.ListAliasesRequest
  ): zio.aws.kms.model.ListAliasesRequest.ReadOnly = new Wrapper(impl)
}
