package zio.aws.kms.model
import scala.jdk.CollectionConverters.*
sealed trait GrantOperation {
  def unwrap: software.amazon.awssdk.services.kms.model.GrantOperation
}
object GrantOperation {
  def wrap(
      value: software.amazon.awssdk.services.kms.model.GrantOperation
  ): zio.aws.kms.model.GrantOperation = value match {
    case software.amazon.awssdk.services.kms.model.GrantOperation.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kms.model.GrantOperation.DECRYPT =>
      val r = Decrypt
      r
    case software.amazon.awssdk.services.kms.model.GrantOperation.ENCRYPT =>
      val r = Encrypt
      r
    case software.amazon.awssdk.services.kms.model.GrantOperation.GENERATE_DATA_KEY =>
      val r = GenerateDataKey
      r
    case software.amazon.awssdk.services.kms.model.GrantOperation.GENERATE_DATA_KEY_WITHOUT_PLAINTEXT =>
      val r = GenerateDataKeyWithoutPlaintext
      r
    case software.amazon.awssdk.services.kms.model.GrantOperation.RE_ENCRYPT_FROM =>
      val r = ReEncryptFrom
      r
    case software.amazon.awssdk.services.kms.model.GrantOperation.RE_ENCRYPT_TO =>
      val r = ReEncryptTo
      r
    case software.amazon.awssdk.services.kms.model.GrantOperation.SIGN =>
      val r = Sign
      r
    case software.amazon.awssdk.services.kms.model.GrantOperation.VERIFY =>
      val r = Verify
      r
    case software.amazon.awssdk.services.kms.model.GrantOperation.GET_PUBLIC_KEY =>
      val r = GetPublicKey
      r
    case software.amazon.awssdk.services.kms.model.GrantOperation.CREATE_GRANT =>
      val r = CreateGrant
      r
    case software.amazon.awssdk.services.kms.model.GrantOperation.RETIRE_GRANT =>
      val r = RetireGrant
      r
    case software.amazon.awssdk.services.kms.model.GrantOperation.DESCRIBE_KEY =>
      val r = DescribeKey
      r
    case software.amazon.awssdk.services.kms.model.GrantOperation.GENERATE_DATA_KEY_PAIR =>
      val r = GenerateDataKeyPair
      r
    case software.amazon.awssdk.services.kms.model.GrantOperation.GENERATE_DATA_KEY_PAIR_WITHOUT_PLAINTEXT =>
      val r = GenerateDataKeyPairWithoutPlaintext
      r
  }
  case object unknownToSdkVersion extends zio.aws.kms.model.GrantOperation {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.GrantOperation =
      software.amazon.awssdk.services.kms.model.GrantOperation.UNKNOWN_TO_SDK_VERSION
  }
  case object Decrypt extends zio.aws.kms.model.GrantOperation {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.GrantOperation =
      software.amazon.awssdk.services.kms.model.GrantOperation.DECRYPT
  }
  case object Encrypt extends zio.aws.kms.model.GrantOperation {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.GrantOperation =
      software.amazon.awssdk.services.kms.model.GrantOperation.ENCRYPT
  }
  case object GenerateDataKey extends zio.aws.kms.model.GrantOperation {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.GrantOperation =
      software.amazon.awssdk.services.kms.model.GrantOperation.GENERATE_DATA_KEY
  }
  case object GenerateDataKeyWithoutPlaintext
      extends zio.aws.kms.model.GrantOperation {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.GrantOperation =
      software.amazon.awssdk.services.kms.model.GrantOperation.GENERATE_DATA_KEY_WITHOUT_PLAINTEXT
  }
  case object ReEncryptFrom extends zio.aws.kms.model.GrantOperation {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.GrantOperation =
      software.amazon.awssdk.services.kms.model.GrantOperation.RE_ENCRYPT_FROM
  }
  case object ReEncryptTo extends zio.aws.kms.model.GrantOperation {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.GrantOperation =
      software.amazon.awssdk.services.kms.model.GrantOperation.RE_ENCRYPT_TO
  }
  case object Sign extends zio.aws.kms.model.GrantOperation {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.GrantOperation =
      software.amazon.awssdk.services.kms.model.GrantOperation.SIGN
  }
  case object Verify extends zio.aws.kms.model.GrantOperation {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.GrantOperation =
      software.amazon.awssdk.services.kms.model.GrantOperation.VERIFY
  }
  case object GetPublicKey extends zio.aws.kms.model.GrantOperation {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.GrantOperation =
      software.amazon.awssdk.services.kms.model.GrantOperation.GET_PUBLIC_KEY
  }
  case object CreateGrant extends zio.aws.kms.model.GrantOperation {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.GrantOperation =
      software.amazon.awssdk.services.kms.model.GrantOperation.CREATE_GRANT
  }
  case object RetireGrant extends zio.aws.kms.model.GrantOperation {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.GrantOperation =
      software.amazon.awssdk.services.kms.model.GrantOperation.RETIRE_GRANT
  }
  case object DescribeKey extends zio.aws.kms.model.GrantOperation {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.GrantOperation =
      software.amazon.awssdk.services.kms.model.GrantOperation.DESCRIBE_KEY
  }
  case object GenerateDataKeyPair extends zio.aws.kms.model.GrantOperation {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.GrantOperation =
      software.amazon.awssdk.services.kms.model.GrantOperation.GENERATE_DATA_KEY_PAIR
  }
  case object GenerateDataKeyPairWithoutPlaintext
      extends zio.aws.kms.model.GrantOperation {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.GrantOperation =
      software.amazon.awssdk.services.kms.model.GrantOperation.GENERATE_DATA_KEY_PAIR_WITHOUT_PLAINTEXT
  }
}
