package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.kms.model.primitives.{PolicyNameType, KeyIdType}
import scala.jdk.CollectionConverters.*
final case class GetKeyPolicyRequest(
    keyId: KeyIdType,
    policyName: PolicyNameType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.GetKeyPolicyRequest = {
    import GetKeyPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.GetKeyPolicyRequest
      .builder()
      .keyId(KeyIdType.unwrap(keyId): java.lang.String)
      .policyName(PolicyNameType.unwrap(policyName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.GetKeyPolicyRequest.ReadOnly =
    zio.aws.kms.model.GetKeyPolicyRequest.wrap(buildAwsValue())
}
object GetKeyPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.GetKeyPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.GetKeyPolicyRequest =
      zio.aws.kms.model.GetKeyPolicyRequest(keyId, policyName)
    def keyId: KeyIdType
    def policyName: PolicyNameType
    def getKeyId: ZIO[Any, Nothing, KeyIdType] = ZIO.succeed(keyId)
    def getPolicyName: ZIO[Any, Nothing, PolicyNameType] =
      ZIO.succeed(policyName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.GetKeyPolicyRequest
  ) extends zio.aws.kms.model.GetKeyPolicyRequest.ReadOnly {
    override val keyId: KeyIdType =
      zio.aws.kms.model.primitives.KeyIdType(impl.keyId())
    override val policyName: PolicyNameType =
      zio.aws.kms.model.primitives.PolicyNameType(impl.policyName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.GetKeyPolicyRequest
  ): zio.aws.kms.model.GetKeyPolicyRequest.ReadOnly = new Wrapper(impl)
}
