package zio.aws.kms.model
import scala.jdk.CollectionConverters.*
sealed trait EncryptionAlgorithmSpec {
  def unwrap: software.amazon.awssdk.services.kms.model.EncryptionAlgorithmSpec
}
object EncryptionAlgorithmSpec {
  def wrap(
      value: software.amazon.awssdk.services.kms.model.EncryptionAlgorithmSpec
  ): zio.aws.kms.model.EncryptionAlgorithmSpec = value match {
    case software.amazon.awssdk.services.kms.model.EncryptionAlgorithmSpec.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kms.model.EncryptionAlgorithmSpec.SYMMETRIC_DEFAULT =>
      val r = SYMMETRIC_DEFAULT
      r
    case software.amazon.awssdk.services.kms.model.EncryptionAlgorithmSpec.RSAES_OAEP_SHA_1 =>
      val r = RSAES_OAEP_SHA_1
      r
    case software.amazon.awssdk.services.kms.model.EncryptionAlgorithmSpec.RSAES_OAEP_SHA_256 =>
      val r = RSAES_OAEP_SHA_256
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.kms.model.EncryptionAlgorithmSpec {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.EncryptionAlgorithmSpec =
      software.amazon.awssdk.services.kms.model.EncryptionAlgorithmSpec.UNKNOWN_TO_SDK_VERSION
  }
  case object SYMMETRIC_DEFAULT
      extends zio.aws.kms.model.EncryptionAlgorithmSpec {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.EncryptionAlgorithmSpec =
      software.amazon.awssdk.services.kms.model.EncryptionAlgorithmSpec.SYMMETRIC_DEFAULT
  }
  case object RSAES_OAEP_SHA_1
      extends zio.aws.kms.model.EncryptionAlgorithmSpec {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.EncryptionAlgorithmSpec =
      software.amazon.awssdk.services.kms.model.EncryptionAlgorithmSpec.RSAES_OAEP_SHA_1
  }
  case object RSAES_OAEP_SHA_256
      extends zio.aws.kms.model.EncryptionAlgorithmSpec {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.EncryptionAlgorithmSpec =
      software.amazon.awssdk.services.kms.model.EncryptionAlgorithmSpec.RSAES_OAEP_SHA_256
  }
}
