package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{
  GrantTokenType,
  KeyIdType,
  EncryptionContextValue,
  PlaintextType,
  EncryptionContextKey
}
import scala.jdk.CollectionConverters.*
final case class EncryptRequest(
    keyId: KeyIdType,
    plaintext: PlaintextType,
    encryptionContext: Option[
      Map[EncryptionContextKey, EncryptionContextValue]
    ] = None,
    grantTokens: Option[Iterable[GrantTokenType]] = None,
    encryptionAlgorithm: Option[zio.aws.kms.model.EncryptionAlgorithmSpec] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.EncryptRequest = {
    import EncryptRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.EncryptRequest
      .builder()
      .keyId(KeyIdType.unwrap(keyId): java.lang.String)
      .plaintext(
        software.amazon.awssdk.core.SdkBytes
          .fromByteArrayUnsafe(plaintext.toArray[Byte])
      )
      .optionallyWith(
        encryptionContext.map(value =>
          value
            .map({ case (key, value) =>
              (EncryptionContextKey.unwrap(
                key
              ): java.lang.String) -> (EncryptionContextValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.encryptionContext)
      .optionallyWith(
        grantTokens.map(value =>
          value.map { item =>
            GrantTokenType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.grantTokens)
      .optionallyWith(encryptionAlgorithm.map(value => value.unwrap))(
        _.encryptionAlgorithm
      )
      .build()
  }
  def asReadOnly: zio.aws.kms.model.EncryptRequest.ReadOnly =
    zio.aws.kms.model.EncryptRequest.wrap(buildAwsValue())
}
object EncryptRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.EncryptRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.EncryptRequest =
      zio.aws.kms.model.EncryptRequest(
        keyId,
        plaintext,
        encryptionContext.map(value => value),
        grantTokens.map(value => value),
        encryptionAlgorithm.map(value => value)
      )
    def keyId: KeyIdType
    def plaintext: PlaintextType
    def encryptionContext
        : Option[Map[EncryptionContextKey, EncryptionContextValue]]
    def grantTokens: Option[List[GrantTokenType]]
    def encryptionAlgorithm: Option[zio.aws.kms.model.EncryptionAlgorithmSpec]
    def getKeyId: ZIO[Any, Nothing, KeyIdType] = ZIO.succeed(keyId)
    def getPlaintext: ZIO[Any, Nothing, PlaintextType] = ZIO.succeed(plaintext)
    def getEncryptionContext: ZIO[Any, AwsError, Map[
      EncryptionContextKey,
      EncryptionContextValue
    ]] = AwsError.unwrapOptionField("encryptionContext", encryptionContext)
    def getGrantTokens: ZIO[Any, AwsError, List[GrantTokenType]] =
      AwsError.unwrapOptionField("grantTokens", grantTokens)
    def getEncryptionAlgorithm
        : ZIO[Any, AwsError, zio.aws.kms.model.EncryptionAlgorithmSpec] =
      AwsError.unwrapOptionField("encryptionAlgorithm", encryptionAlgorithm)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.EncryptRequest
  ) extends zio.aws.kms.model.EncryptRequest.ReadOnly {
    override val keyId: KeyIdType =
      zio.aws.kms.model.primitives.KeyIdType(impl.keyId())
    override val plaintext: PlaintextType = zio.aws.kms.model.primitives
      .PlaintextType(zio.Chunk.fromArray(impl.plaintext().asByteArrayUnsafe()))
    override val encryptionContext
        : Option[Map[EncryptionContextKey, EncryptionContextValue]] = scala
      .Option(impl.encryptionContext())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.kms.model.primitives.EncryptionContextKey(
              key
            ) -> zio.aws.kms.model.primitives.EncryptionContextValue(value)
          })
          .toMap
      )
    override val grantTokens: Option[List[GrantTokenType]] = scala
      .Option(impl.grantTokens())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kms.model.primitives.GrantTokenType(item)
        }.toList
      )
    override val encryptionAlgorithm
        : Option[zio.aws.kms.model.EncryptionAlgorithmSpec] = scala
      .Option(impl.encryptionAlgorithm())
      .map(value => zio.aws.kms.model.EncryptionAlgorithmSpec.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.EncryptRequest
  ): zio.aws.kms.model.EncryptRequest.ReadOnly = new Wrapper(impl)
}
