package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.kms.model.primitives.KeyIdType
import scala.jdk.CollectionConverters.*
final case class EnableKeyRotationRequest(keyId: KeyIdType) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.EnableKeyRotationRequest = {
    import EnableKeyRotationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.EnableKeyRotationRequest
      .builder()
      .keyId(KeyIdType.unwrap(keyId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.EnableKeyRotationRequest.ReadOnly =
    zio.aws.kms.model.EnableKeyRotationRequest.wrap(buildAwsValue())
}
object EnableKeyRotationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.EnableKeyRotationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.EnableKeyRotationRequest =
      zio.aws.kms.model.EnableKeyRotationRequest(keyId)
    def keyId: KeyIdType
    def getKeyId: ZIO[Any, Nothing, KeyIdType] = ZIO.succeed(keyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.EnableKeyRotationRequest
  ) extends zio.aws.kms.model.EnableKeyRotationRequest.ReadOnly {
    override val keyId: KeyIdType =
      zio.aws.kms.model.primitives.KeyIdType(impl.keyId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.EnableKeyRotationRequest
  ): zio.aws.kms.model.EnableKeyRotationRequest.ReadOnly = new Wrapper(impl)
}
