package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{PlaintextType, KeyIdType}
import scala.jdk.CollectionConverters.*
final case class DecryptResponse(
    keyId: Option[KeyIdType] = None,
    plaintext: Option[PlaintextType] = None,
    encryptionAlgorithm: Option[zio.aws.kms.model.EncryptionAlgorithmSpec] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.DecryptResponse = {
    import DecryptResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.DecryptResponse
      .builder()
      .optionallyWith(
        keyId.map(value => KeyIdType.unwrap(value): java.lang.String)
      )(_.keyId)
      .optionallyWith(
        plaintext.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.plaintext)
      .optionallyWith(encryptionAlgorithm.map(value => value.unwrap))(
        _.encryptionAlgorithm
      )
      .build()
  }
  def asReadOnly: zio.aws.kms.model.DecryptResponse.ReadOnly =
    zio.aws.kms.model.DecryptResponse.wrap(buildAwsValue())
}
object DecryptResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.DecryptResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.DecryptResponse =
      zio.aws.kms.model.DecryptResponse(
        keyId.map(value => value),
        plaintext.map(value => value),
        encryptionAlgorithm.map(value => value)
      )
    def keyId: Option[KeyIdType]
    def plaintext: Option[PlaintextType]
    def encryptionAlgorithm: Option[zio.aws.kms.model.EncryptionAlgorithmSpec]
    def getKeyId: ZIO[Any, AwsError, KeyIdType] =
      AwsError.unwrapOptionField("keyId", keyId)
    def getPlaintext: ZIO[Any, AwsError, PlaintextType] =
      AwsError.unwrapOptionField("plaintext", plaintext)
    def getEncryptionAlgorithm
        : ZIO[Any, AwsError, zio.aws.kms.model.EncryptionAlgorithmSpec] =
      AwsError.unwrapOptionField("encryptionAlgorithm", encryptionAlgorithm)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.DecryptResponse
  ) extends zio.aws.kms.model.DecryptResponse.ReadOnly {
    override val keyId: Option[KeyIdType] = scala
      .Option(impl.keyId())
      .map(value => zio.aws.kms.model.primitives.KeyIdType(value))
    override val plaintext: Option[PlaintextType] = scala
      .Option(impl.plaintext())
      .map(value =>
        zio.aws.kms.model.primitives
          .PlaintextType(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
    override val encryptionAlgorithm
        : Option[zio.aws.kms.model.EncryptionAlgorithmSpec] = scala
      .Option(impl.encryptionAlgorithm())
      .map(value => zio.aws.kms.model.EncryptionAlgorithmSpec.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.DecryptResponse
  ): zio.aws.kms.model.DecryptResponse.ReadOnly = new Wrapper(impl)
}
