package zio.aws.kms.model
import scala.jdk.CollectionConverters.*
sealed trait AlgorithmSpec {
  def unwrap: software.amazon.awssdk.services.kms.model.AlgorithmSpec
}
object AlgorithmSpec {
  def wrap(
      value: software.amazon.awssdk.services.kms.model.AlgorithmSpec
  ): zio.aws.kms.model.AlgorithmSpec = value match {
    case software.amazon.awssdk.services.kms.model.AlgorithmSpec.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kms.model.AlgorithmSpec.RSAES_PKCS1_V1_5 =>
      val r = RSAES_PKCS1_V1_5
      r
    case software.amazon.awssdk.services.kms.model.AlgorithmSpec.RSAES_OAEP_SHA_1 =>
      val r = RSAES_OAEP_SHA_1
      r
    case software.amazon.awssdk.services.kms.model.AlgorithmSpec.RSAES_OAEP_SHA_256 =>
      val r = RSAES_OAEP_SHA_256
      r
  }
  case object unknownToSdkVersion extends zio.aws.kms.model.AlgorithmSpec {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.AlgorithmSpec =
      software.amazon.awssdk.services.kms.model.AlgorithmSpec.UNKNOWN_TO_SDK_VERSION
  }
  case object RSAES_PKCS1_V1_5 extends zio.aws.kms.model.AlgorithmSpec {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.AlgorithmSpec =
      software.amazon.awssdk.services.kms.model.AlgorithmSpec.RSAES_PKCS1_V1_5
  }
  case object RSAES_OAEP_SHA_1 extends zio.aws.kms.model.AlgorithmSpec {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.AlgorithmSpec =
      software.amazon.awssdk.services.kms.model.AlgorithmSpec.RSAES_OAEP_SHA_1
  }
  case object RSAES_OAEP_SHA_256 extends zio.aws.kms.model.AlgorithmSpec {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.AlgorithmSpec =
      software.amazon.awssdk.services.kms.model.AlgorithmSpec.RSAES_OAEP_SHA_256
  }
}
