package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{BooleanType, KeyIdType}
import scala.jdk.CollectionConverters.*
final case class VerifyResponse(
    keyId: Option[KeyIdType] = None,
    signatureValid: Option[BooleanType] = None,
    signingAlgorithm: Option[zio.aws.kms.model.SigningAlgorithmSpec] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.VerifyResponse = {
    import VerifyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.VerifyResponse
      .builder()
      .optionallyWith(
        keyId.map(value => KeyIdType.unwrap(value): java.lang.String)
      )(_.keyId)
      .optionallyWith(
        signatureValid.map(value =>
          BooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.signatureValid)
      .optionallyWith(signingAlgorithm.map(value => value.unwrap))(
        _.signingAlgorithm
      )
      .build()
  }
  def asReadOnly: zio.aws.kms.model.VerifyResponse.ReadOnly =
    zio.aws.kms.model.VerifyResponse.wrap(buildAwsValue())
}
object VerifyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.VerifyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.VerifyResponse =
      zio.aws.kms.model.VerifyResponse(
        keyId.map(value => value),
        signatureValid.map(value => value),
        signingAlgorithm.map(value => value)
      )
    def keyId: Option[KeyIdType]
    def signatureValid: Option[BooleanType]
    def signingAlgorithm: Option[zio.aws.kms.model.SigningAlgorithmSpec]
    def getKeyId: ZIO[Any, AwsError, KeyIdType] =
      AwsError.unwrapOptionField("keyId", keyId)
    def getSignatureValid: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("signatureValid", signatureValid)
    def getSigningAlgorithm
        : ZIO[Any, AwsError, zio.aws.kms.model.SigningAlgorithmSpec] =
      AwsError.unwrapOptionField("signingAlgorithm", signingAlgorithm)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.VerifyResponse
  ) extends zio.aws.kms.model.VerifyResponse.ReadOnly {
    override val keyId: Option[KeyIdType] = scala
      .Option(impl.keyId())
      .map(value => zio.aws.kms.model.primitives.KeyIdType(value))
    override val signatureValid: Option[BooleanType] = scala
      .Option(impl.signatureValid())
      .map(value => zio.aws.kms.model.primitives.BooleanType(value))
    override val signingAlgorithm
        : Option[zio.aws.kms.model.SigningAlgorithmSpec] = scala
      .Option(impl.signingAlgorithm())
      .map(value => zio.aws.kms.model.SigningAlgorithmSpec.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.VerifyResponse
  ): zio.aws.kms.model.VerifyResponse.ReadOnly = new Wrapper(impl)
}
