package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.kms.model.primitives.{GrantIdType, KeyIdType}
import scala.jdk.CollectionConverters.*
final case class RevokeGrantRequest(keyId: KeyIdType, grantId: GrantIdType) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.RevokeGrantRequest = {
    import RevokeGrantRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.RevokeGrantRequest
      .builder()
      .keyId(KeyIdType.unwrap(keyId): java.lang.String)
      .grantId(GrantIdType.unwrap(grantId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.RevokeGrantRequest.ReadOnly =
    zio.aws.kms.model.RevokeGrantRequest.wrap(buildAwsValue())
}
object RevokeGrantRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.RevokeGrantRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.RevokeGrantRequest =
      zio.aws.kms.model.RevokeGrantRequest(keyId, grantId)
    def keyId: KeyIdType
    def grantId: GrantIdType
    def getKeyId: ZIO[Any, Nothing, KeyIdType] = ZIO.succeed(keyId)
    def getGrantId: ZIO[Any, Nothing, GrantIdType] = ZIO.succeed(grantId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.RevokeGrantRequest
  ) extends zio.aws.kms.model.RevokeGrantRequest.ReadOnly {
    override val keyId: KeyIdType =
      zio.aws.kms.model.primitives.KeyIdType(impl.keyId())
    override val grantId: GrantIdType =
      zio.aws.kms.model.primitives.GrantIdType(impl.grantId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.RevokeGrantRequest
  ): zio.aws.kms.model.RevokeGrantRequest.ReadOnly = new Wrapper(impl)
}
