package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class MultiRegionConfiguration(
    multiRegionKeyType: Option[zio.aws.kms.model.MultiRegionKeyType] = None,
    primaryKey: Option[zio.aws.kms.model.MultiRegionKey] = None,
    replicaKeys: Option[Iterable[zio.aws.kms.model.MultiRegionKey]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.MultiRegionConfiguration = {
    import MultiRegionConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.MultiRegionConfiguration
      .builder()
      .optionallyWith(multiRegionKeyType.map(value => value.unwrap))(
        _.multiRegionKeyType
      )
      .optionallyWith(primaryKey.map(value => value.buildAwsValue()))(
        _.primaryKey
      )
      .optionallyWith(
        replicaKeys.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.replicaKeys)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.MultiRegionConfiguration.ReadOnly =
    zio.aws.kms.model.MultiRegionConfiguration.wrap(buildAwsValue())
}
object MultiRegionConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.MultiRegionConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.MultiRegionConfiguration =
      zio.aws.kms.model.MultiRegionConfiguration(
        multiRegionKeyType.map(value => value),
        primaryKey.map(value => value.asEditable),
        replicaKeys.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def multiRegionKeyType: Option[zio.aws.kms.model.MultiRegionKeyType]
    def primaryKey: Option[zio.aws.kms.model.MultiRegionKey.ReadOnly]
    def replicaKeys: Option[List[zio.aws.kms.model.MultiRegionKey.ReadOnly]]
    def getMultiRegionKeyType
        : ZIO[Any, AwsError, zio.aws.kms.model.MultiRegionKeyType] =
      AwsError.unwrapOptionField("multiRegionKeyType", multiRegionKeyType)
    def getPrimaryKey
        : ZIO[Any, AwsError, zio.aws.kms.model.MultiRegionKey.ReadOnly] =
      AwsError.unwrapOptionField("primaryKey", primaryKey)
    def getReplicaKeys
        : ZIO[Any, AwsError, List[zio.aws.kms.model.MultiRegionKey.ReadOnly]] =
      AwsError.unwrapOptionField("replicaKeys", replicaKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.MultiRegionConfiguration
  ) extends zio.aws.kms.model.MultiRegionConfiguration.ReadOnly {
    override val multiRegionKeyType
        : Option[zio.aws.kms.model.MultiRegionKeyType] = scala
      .Option(impl.multiRegionKeyType())
      .map(value => zio.aws.kms.model.MultiRegionKeyType.wrap(value))
    override val primaryKey: Option[zio.aws.kms.model.MultiRegionKey.ReadOnly] =
      scala
        .Option(impl.primaryKey())
        .map(value => zio.aws.kms.model.MultiRegionKey.wrap(value))
    override val replicaKeys
        : Option[List[zio.aws.kms.model.MultiRegionKey.ReadOnly]] = scala
      .Option(impl.replicaKeys())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kms.model.MultiRegionKey.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.MultiRegionConfiguration
  ): zio.aws.kms.model.MultiRegionConfiguration.ReadOnly = new Wrapper(impl)
}
