package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{BooleanType, MarkerType}
import scala.jdk.CollectionConverters.*
final case class ListResourceTagsResponse(
    tags: Option[Iterable[zio.aws.kms.model.Tag]] = None,
    nextMarker: Option[MarkerType] = None,
    truncated: Option[BooleanType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.ListResourceTagsResponse = {
    import ListResourceTagsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.ListResourceTagsResponse
      .builder()
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        nextMarker.map(value => MarkerType.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .optionallyWith(
        truncated.map(value => BooleanType.unwrap(value): java.lang.Boolean)
      )(_.truncated)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.ListResourceTagsResponse.ReadOnly =
    zio.aws.kms.model.ListResourceTagsResponse.wrap(buildAwsValue())
}
object ListResourceTagsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.ListResourceTagsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.ListResourceTagsResponse =
      zio.aws.kms.model.ListResourceTagsResponse(
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextMarker.map(value => value),
        truncated.map(value => value)
      )
    def tags: Option[List[zio.aws.kms.model.Tag.ReadOnly]]
    def nextMarker: Option[MarkerType]
    def truncated: Option[BooleanType]
    def getTags: ZIO[Any, AwsError, List[zio.aws.kms.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getNextMarker: ZIO[Any, AwsError, MarkerType] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getTruncated: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("truncated", truncated)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.ListResourceTagsResponse
  ) extends zio.aws.kms.model.ListResourceTagsResponse.ReadOnly {
    override val tags: Option[List[zio.aws.kms.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kms.model.Tag.wrap(item)
        }.toList
      )
    override val nextMarker: Option[MarkerType] = scala
      .Option(impl.nextMarker())
      .map(value => zio.aws.kms.model.primitives.MarkerType(value))
    override val truncated: Option[BooleanType] = scala
      .Option(impl.truncated())
      .map(value => zio.aws.kms.model.primitives.BooleanType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.ListResourceTagsResponse
  ): zio.aws.kms.model.ListResourceTagsResponse.ReadOnly = new Wrapper(impl)
}
