package zio.aws.kms.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{MarkerType, LimitType}
import scala.jdk.CollectionConverters.*
final case class ListKeysRequest(
    limit: Option[LimitType] = None,
    marker: Option[MarkerType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.ListKeysRequest = {
    import ListKeysRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.ListKeysRequest
      .builder()
      .optionallyWith(limit.map(value => LimitType.unwrap(value): Integer))(
        _.limit
      )
      .optionallyWith(
        marker.map(value => MarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.ListKeysRequest.ReadOnly =
    zio.aws.kms.model.ListKeysRequest.wrap(buildAwsValue())
}
object ListKeysRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.ListKeysRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.ListKeysRequest = zio.aws.kms.model
      .ListKeysRequest(limit.map(value => value), marker.map(value => value))
    def limit: Option[LimitType]
    def marker: Option[MarkerType]
    def getLimit: ZIO[Any, AwsError, LimitType] =
      AwsError.unwrapOptionField("limit", limit)
    def getMarker: ZIO[Any, AwsError, MarkerType] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.ListKeysRequest
  ) extends zio.aws.kms.model.ListKeysRequest.ReadOnly {
    override val limit: Option[LimitType] = scala
      .Option(impl.limit())
      .map(value => zio.aws.kms.model.primitives.LimitType(value))
    override val marker: Option[MarkerType] = scala
      .Option(impl.marker())
      .map(value => zio.aws.kms.model.primitives.MarkerType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.ListKeysRequest
  ): zio.aws.kms.model.ListKeysRequest.ReadOnly = new Wrapper(impl)
}
