package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{BooleanType, MarkerType, PolicyNameType}
import scala.jdk.CollectionConverters.*
final case class ListKeyPoliciesResponse(
    policyNames: Option[Iterable[PolicyNameType]] = None,
    nextMarker: Option[MarkerType] = None,
    truncated: Option[BooleanType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.ListKeyPoliciesResponse = {
    import ListKeyPoliciesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.ListKeyPoliciesResponse
      .builder()
      .optionallyWith(
        policyNames.map(value =>
          value.map { item =>
            PolicyNameType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.policyNames)
      .optionallyWith(
        nextMarker.map(value => MarkerType.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .optionallyWith(
        truncated.map(value => BooleanType.unwrap(value): java.lang.Boolean)
      )(_.truncated)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.ListKeyPoliciesResponse.ReadOnly =
    zio.aws.kms.model.ListKeyPoliciesResponse.wrap(buildAwsValue())
}
object ListKeyPoliciesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.ListKeyPoliciesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.ListKeyPoliciesResponse =
      zio.aws.kms.model.ListKeyPoliciesResponse(
        policyNames.map(value => value),
        nextMarker.map(value => value),
        truncated.map(value => value)
      )
    def policyNames: Option[List[PolicyNameType]]
    def nextMarker: Option[MarkerType]
    def truncated: Option[BooleanType]
    def getPolicyNames: ZIO[Any, AwsError, List[PolicyNameType]] =
      AwsError.unwrapOptionField("policyNames", policyNames)
    def getNextMarker: ZIO[Any, AwsError, MarkerType] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getTruncated: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("truncated", truncated)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.ListKeyPoliciesResponse
  ) extends zio.aws.kms.model.ListKeyPoliciesResponse.ReadOnly {
    override val policyNames: Option[List[PolicyNameType]] = scala
      .Option(impl.policyNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kms.model.primitives.PolicyNameType(item)
        }.toList
      )
    override val nextMarker: Option[MarkerType] = scala
      .Option(impl.nextMarker())
      .map(value => zio.aws.kms.model.primitives.MarkerType(value))
    override val truncated: Option[BooleanType] = scala
      .Option(impl.truncated())
      .map(value => zio.aws.kms.model.primitives.BooleanType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.ListKeyPoliciesResponse
  ): zio.aws.kms.model.ListKeyPoliciesResponse.ReadOnly = new Wrapper(impl)
}
