package zio.aws.kms.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{
  KeyIdType,
  GrantIdType,
  PrincipalIdType,
  LimitType,
  MarkerType
}
import scala.jdk.CollectionConverters.*
final case class ListGrantsRequest(
    limit: Option[LimitType] = None,
    marker: Option[MarkerType] = None,
    keyId: KeyIdType,
    grantId: Option[GrantIdType] = None,
    granteePrincipal: Option[PrincipalIdType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.ListGrantsRequest = {
    import ListGrantsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.ListGrantsRequest
      .builder()
      .optionallyWith(limit.map(value => LimitType.unwrap(value): Integer))(
        _.limit
      )
      .optionallyWith(
        marker.map(value => MarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .keyId(KeyIdType.unwrap(keyId): java.lang.String)
      .optionallyWith(
        grantId.map(value => GrantIdType.unwrap(value): java.lang.String)
      )(_.grantId)
      .optionallyWith(
        granteePrincipal.map(value =>
          PrincipalIdType.unwrap(value): java.lang.String
        )
      )(_.granteePrincipal)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.ListGrantsRequest.ReadOnly =
    zio.aws.kms.model.ListGrantsRequest.wrap(buildAwsValue())
}
object ListGrantsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.ListGrantsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.ListGrantsRequest =
      zio.aws.kms.model.ListGrantsRequest(
        limit.map(value => value),
        marker.map(value => value),
        keyId,
        grantId.map(value => value),
        granteePrincipal.map(value => value)
      )
    def limit: Option[LimitType]
    def marker: Option[MarkerType]
    def keyId: KeyIdType
    def grantId: Option[GrantIdType]
    def granteePrincipal: Option[PrincipalIdType]
    def getLimit: ZIO[Any, AwsError, LimitType] =
      AwsError.unwrapOptionField("limit", limit)
    def getMarker: ZIO[Any, AwsError, MarkerType] =
      AwsError.unwrapOptionField("marker", marker)
    def getKeyId: ZIO[Any, Nothing, KeyIdType] = ZIO.succeed(keyId)
    def getGrantId: ZIO[Any, AwsError, GrantIdType] =
      AwsError.unwrapOptionField("grantId", grantId)
    def getGranteePrincipal: ZIO[Any, AwsError, PrincipalIdType] =
      AwsError.unwrapOptionField("granteePrincipal", granteePrincipal)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.ListGrantsRequest
  ) extends zio.aws.kms.model.ListGrantsRequest.ReadOnly {
    override val limit: Option[LimitType] = scala
      .Option(impl.limit())
      .map(value => zio.aws.kms.model.primitives.LimitType(value))
    override val marker: Option[MarkerType] = scala
      .Option(impl.marker())
      .map(value => zio.aws.kms.model.primitives.MarkerType(value))
    override val keyId: KeyIdType =
      zio.aws.kms.model.primitives.KeyIdType(impl.keyId())
    override val grantId: Option[GrantIdType] = scala
      .Option(impl.grantId())
      .map(value => zio.aws.kms.model.primitives.GrantIdType(value))
    override val granteePrincipal: Option[PrincipalIdType] = scala
      .Option(impl.granteePrincipal())
      .map(value => zio.aws.kms.model.primitives.PrincipalIdType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.ListGrantsRequest
  ): zio.aws.kms.model.ListGrantsRequest.ReadOnly = new Wrapper(impl)
}
