package zio.aws.kms.model
import java.time.Instant
import zio.aws.kms.model.primitives.{
  KeyIdType,
  ArnType,
  BooleanType,
  DateType,
  PendingWindowInDaysType,
  CloudHsmClusterIdType,
  CustomKeyStoreIdType,
  DescriptionType,
  AWSAccountIdType,
  NullableBooleanType
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class KeyMetadata(
    awsAccountId: Option[AWSAccountIdType] = None,
    keyId: KeyIdType,
    arn: Option[ArnType] = None,
    creationDate: Option[DateType] = None,
    enabled: Option[BooleanType] = None,
    description: Option[DescriptionType] = None,
    keyUsage: Option[zio.aws.kms.model.KeyUsageType] = None,
    keyState: Option[zio.aws.kms.model.KeyState] = None,
    deletionDate: Option[DateType] = None,
    validTo: Option[DateType] = None,
    origin: Option[zio.aws.kms.model.OriginType] = None,
    customKeyStoreId: Option[CustomKeyStoreIdType] = None,
    cloudHsmClusterId: Option[CloudHsmClusterIdType] = None,
    expirationModel: Option[zio.aws.kms.model.ExpirationModelType] = None,
    keyManager: Option[zio.aws.kms.model.KeyManagerType] = None,
    customerMasterKeySpec: Option[zio.aws.kms.model.CustomerMasterKeySpec] =
      None,
    keySpec: Option[zio.aws.kms.model.KeySpec] = None,
    encryptionAlgorithms: Option[
      Iterable[zio.aws.kms.model.EncryptionAlgorithmSpec]
    ] = None,
    signingAlgorithms: Option[
      Iterable[zio.aws.kms.model.SigningAlgorithmSpec]
    ] = None,
    multiRegion: Option[NullableBooleanType] = None,
    multiRegionConfiguration: Option[
      zio.aws.kms.model.MultiRegionConfiguration
    ] = None,
    pendingDeletionWindowInDays: Option[PendingWindowInDaysType] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.kms.model.KeyMetadata = {
    import KeyMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.KeyMetadata
      .builder()
      .optionallyWith(
        awsAccountId.map(value =>
          AWSAccountIdType.unwrap(value): java.lang.String
        )
      )(_.awsAccountId)
      .keyId(KeyIdType.unwrap(keyId): java.lang.String)
      .optionallyWith(
        arn.map(value => ArnType.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        creationDate.map(value => DateType.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        enabled.map(value => BooleanType.unwrap(value): java.lang.Boolean)
      )(_.enabled)
      .optionallyWith(
        description.map(value =>
          DescriptionType.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(keyUsage.map(value => value.unwrap))(_.keyUsage)
      .optionallyWith(keyState.map(value => value.unwrap))(_.keyState)
      .optionallyWith(
        deletionDate.map(value => DateType.unwrap(value): Instant)
      )(_.deletionDate)
      .optionallyWith(validTo.map(value => DateType.unwrap(value): Instant))(
        _.validTo
      )
      .optionallyWith(origin.map(value => value.unwrap))(_.origin)
      .optionallyWith(
        customKeyStoreId.map(value =>
          CustomKeyStoreIdType.unwrap(value): java.lang.String
        )
      )(_.customKeyStoreId)
      .optionallyWith(
        cloudHsmClusterId.map(value =>
          CloudHsmClusterIdType.unwrap(value): java.lang.String
        )
      )(_.cloudHsmClusterId)
      .optionallyWith(expirationModel.map(value => value.unwrap))(
        _.expirationModel
      )
      .optionallyWith(keyManager.map(value => value.unwrap))(_.keyManager)
      .optionallyWith(customerMasterKeySpec.map(value => value.unwrap))(
        _.customerMasterKeySpec
      )
      .optionallyWith(keySpec.map(value => value.unwrap))(_.keySpec)
      .optionallyWith(
        encryptionAlgorithms.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.encryptionAlgorithmsWithStrings)
      .optionallyWith(
        signingAlgorithms.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.signingAlgorithmsWithStrings)
      .optionallyWith(
        multiRegion.map(value =>
          NullableBooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.multiRegion)
      .optionallyWith(
        multiRegionConfiguration.map(value => value.buildAwsValue())
      )(_.multiRegionConfiguration)
      .optionallyWith(
        pendingDeletionWindowInDays.map(value =>
          PendingWindowInDaysType.unwrap(value): Integer
        )
      )(_.pendingDeletionWindowInDays)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.KeyMetadata.ReadOnly =
    zio.aws.kms.model.KeyMetadata.wrap(buildAwsValue())
}
object KeyMetadata {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.kms.model.KeyMetadata] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.KeyMetadata =
      zio.aws.kms.model.KeyMetadata(
        awsAccountId.map(value => value),
        keyId,
        arn.map(value => value),
        creationDate.map(value => value),
        enabled.map(value => value),
        description.map(value => value),
        keyUsage.map(value => value),
        keyState.map(value => value),
        deletionDate.map(value => value),
        validTo.map(value => value),
        origin.map(value => value),
        customKeyStoreId.map(value => value),
        cloudHsmClusterId.map(value => value),
        expirationModel.map(value => value),
        keyManager.map(value => value),
        customerMasterKeySpec.map(value => value),
        keySpec.map(value => value),
        encryptionAlgorithms.map(value => value),
        signingAlgorithms.map(value => value),
        multiRegion.map(value => value),
        multiRegionConfiguration.map(value => value.asEditable),
        pendingDeletionWindowInDays.map(value => value)
      )
    def awsAccountId: Option[AWSAccountIdType]
    def keyId: KeyIdType
    def arn: Option[ArnType]
    def creationDate: Option[DateType]
    def enabled: Option[BooleanType]
    def description: Option[DescriptionType]
    def keyUsage: Option[zio.aws.kms.model.KeyUsageType]
    def keyState: Option[zio.aws.kms.model.KeyState]
    def deletionDate: Option[DateType]
    def validTo: Option[DateType]
    def origin: Option[zio.aws.kms.model.OriginType]
    def customKeyStoreId: Option[CustomKeyStoreIdType]
    def cloudHsmClusterId: Option[CloudHsmClusterIdType]
    def expirationModel: Option[zio.aws.kms.model.ExpirationModelType]
    def keyManager: Option[zio.aws.kms.model.KeyManagerType]
    def customerMasterKeySpec: Option[zio.aws.kms.model.CustomerMasterKeySpec]
    def keySpec: Option[zio.aws.kms.model.KeySpec]
    def encryptionAlgorithms
        : Option[List[zio.aws.kms.model.EncryptionAlgorithmSpec]]
    def signingAlgorithms: Option[List[zio.aws.kms.model.SigningAlgorithmSpec]]
    def multiRegion: Option[NullableBooleanType]
    def multiRegionConfiguration
        : Option[zio.aws.kms.model.MultiRegionConfiguration.ReadOnly]
    def pendingDeletionWindowInDays: Option[PendingWindowInDaysType]
    def getAwsAccountId: ZIO[Any, AwsError, AWSAccountIdType] =
      AwsError.unwrapOptionField("awsAccountId", awsAccountId)
    def getKeyId: ZIO[Any, Nothing, KeyIdType] = ZIO.succeed(keyId)
    def getArn: ZIO[Any, AwsError, ArnType] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreationDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getEnabled: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getDescription: ZIO[Any, AwsError, DescriptionType] =
      AwsError.unwrapOptionField("description", description)
    def getKeyUsage: ZIO[Any, AwsError, zio.aws.kms.model.KeyUsageType] =
      AwsError.unwrapOptionField("keyUsage", keyUsage)
    def getKeyState: ZIO[Any, AwsError, zio.aws.kms.model.KeyState] =
      AwsError.unwrapOptionField("keyState", keyState)
    def getDeletionDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("deletionDate", deletionDate)
    def getValidTo: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("validTo", validTo)
    def getOrigin: ZIO[Any, AwsError, zio.aws.kms.model.OriginType] =
      AwsError.unwrapOptionField("origin", origin)
    def getCustomKeyStoreId: ZIO[Any, AwsError, CustomKeyStoreIdType] =
      AwsError.unwrapOptionField("customKeyStoreId", customKeyStoreId)
    def getCloudHsmClusterId: ZIO[Any, AwsError, CloudHsmClusterIdType] =
      AwsError.unwrapOptionField("cloudHsmClusterId", cloudHsmClusterId)
    def getExpirationModel
        : ZIO[Any, AwsError, zio.aws.kms.model.ExpirationModelType] =
      AwsError.unwrapOptionField("expirationModel", expirationModel)
    def getKeyManager: ZIO[Any, AwsError, zio.aws.kms.model.KeyManagerType] =
      AwsError.unwrapOptionField("keyManager", keyManager)
    def getCustomerMasterKeySpec
        : ZIO[Any, AwsError, zio.aws.kms.model.CustomerMasterKeySpec] =
      AwsError.unwrapOptionField("customerMasterKeySpec", customerMasterKeySpec)
    def getKeySpec: ZIO[Any, AwsError, zio.aws.kms.model.KeySpec] =
      AwsError.unwrapOptionField("keySpec", keySpec)
    def getEncryptionAlgorithms
        : ZIO[Any, AwsError, List[zio.aws.kms.model.EncryptionAlgorithmSpec]] =
      AwsError.unwrapOptionField("encryptionAlgorithms", encryptionAlgorithms)
    def getSigningAlgorithms
        : ZIO[Any, AwsError, List[zio.aws.kms.model.SigningAlgorithmSpec]] =
      AwsError.unwrapOptionField("signingAlgorithms", signingAlgorithms)
    def getMultiRegion: ZIO[Any, AwsError, NullableBooleanType] =
      AwsError.unwrapOptionField("multiRegion", multiRegion)
    def getMultiRegionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kms.model.MultiRegionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "multiRegionConfiguration",
      multiRegionConfiguration
    )
    def getPendingDeletionWindowInDays
        : ZIO[Any, AwsError, PendingWindowInDaysType] =
      AwsError.unwrapOptionField(
        "pendingDeletionWindowInDays",
        pendingDeletionWindowInDays
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.KeyMetadata
  ) extends zio.aws.kms.model.KeyMetadata.ReadOnly {
    override val awsAccountId: Option[AWSAccountIdType] = scala
      .Option(impl.awsAccountId())
      .map(value => zio.aws.kms.model.primitives.AWSAccountIdType(value))
    override val keyId: KeyIdType =
      zio.aws.kms.model.primitives.KeyIdType(impl.keyId())
    override val arn: Option[ArnType] = scala
      .Option(impl.arn())
      .map(value => zio.aws.kms.model.primitives.ArnType(value))
    override val creationDate: Option[DateType] = scala
      .Option(impl.creationDate())
      .map(value => zio.aws.kms.model.primitives.DateType(value))
    override val enabled: Option[BooleanType] = scala
      .Option(impl.enabled())
      .map(value => zio.aws.kms.model.primitives.BooleanType(value))
    override val description: Option[DescriptionType] = scala
      .Option(impl.description())
      .map(value => zio.aws.kms.model.primitives.DescriptionType(value))
    override val keyUsage: Option[zio.aws.kms.model.KeyUsageType] = scala
      .Option(impl.keyUsage())
      .map(value => zio.aws.kms.model.KeyUsageType.wrap(value))
    override val keyState: Option[zio.aws.kms.model.KeyState] = scala
      .Option(impl.keyState())
      .map(value => zio.aws.kms.model.KeyState.wrap(value))
    override val deletionDate: Option[DateType] = scala
      .Option(impl.deletionDate())
      .map(value => zio.aws.kms.model.primitives.DateType(value))
    override val validTo: Option[DateType] = scala
      .Option(impl.validTo())
      .map(value => zio.aws.kms.model.primitives.DateType(value))
    override val origin: Option[zio.aws.kms.model.OriginType] = scala
      .Option(impl.origin())
      .map(value => zio.aws.kms.model.OriginType.wrap(value))
    override val customKeyStoreId: Option[CustomKeyStoreIdType] = scala
      .Option(impl.customKeyStoreId())
      .map(value => zio.aws.kms.model.primitives.CustomKeyStoreIdType(value))
    override val cloudHsmClusterId: Option[CloudHsmClusterIdType] = scala
      .Option(impl.cloudHsmClusterId())
      .map(value => zio.aws.kms.model.primitives.CloudHsmClusterIdType(value))
    override val expirationModel
        : Option[zio.aws.kms.model.ExpirationModelType] = scala
      .Option(impl.expirationModel())
      .map(value => zio.aws.kms.model.ExpirationModelType.wrap(value))
    override val keyManager: Option[zio.aws.kms.model.KeyManagerType] = scala
      .Option(impl.keyManager())
      .map(value => zio.aws.kms.model.KeyManagerType.wrap(value))
    override val customerMasterKeySpec
        : Option[zio.aws.kms.model.CustomerMasterKeySpec] = scala
      .Option(impl.customerMasterKeySpec())
      .map(value => zio.aws.kms.model.CustomerMasterKeySpec.wrap(value))
    override val keySpec: Option[zio.aws.kms.model.KeySpec] = scala
      .Option(impl.keySpec())
      .map(value => zio.aws.kms.model.KeySpec.wrap(value))
    override val encryptionAlgorithms
        : Option[List[zio.aws.kms.model.EncryptionAlgorithmSpec]] = scala
      .Option(impl.encryptionAlgorithms())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kms.model.EncryptionAlgorithmSpec.wrap(item)
        }.toList
      )
    override val signingAlgorithms
        : Option[List[zio.aws.kms.model.SigningAlgorithmSpec]] = scala
      .Option(impl.signingAlgorithms())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kms.model.SigningAlgorithmSpec.wrap(item)
        }.toList
      )
    override val multiRegion: Option[NullableBooleanType] = scala
      .Option(impl.multiRegion())
      .map(value => zio.aws.kms.model.primitives.NullableBooleanType(value))
    override val multiRegionConfiguration
        : Option[zio.aws.kms.model.MultiRegionConfiguration.ReadOnly] = scala
      .Option(impl.multiRegionConfiguration())
      .map(value => zio.aws.kms.model.MultiRegionConfiguration.wrap(value))
    override val pendingDeletionWindowInDays: Option[PendingWindowInDaysType] =
      scala
        .Option(impl.pendingDeletionWindowInDays())
        .map(value =>
          zio.aws.kms.model.primitives.PendingWindowInDaysType(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.KeyMetadata
  ): zio.aws.kms.model.KeyMetadata.ReadOnly = new Wrapper(impl)
}
