package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{ArnType, KeyIdType}
import scala.jdk.CollectionConverters.*
final case class KeyListEntry(
    keyId: Option[KeyIdType] = None,
    keyArn: Option[ArnType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.KeyListEntry = {
    import KeyListEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.KeyListEntry
      .builder()
      .optionallyWith(
        keyId.map(value => KeyIdType.unwrap(value): java.lang.String)
      )(_.keyId)
      .optionallyWith(
        keyArn.map(value => ArnType.unwrap(value): java.lang.String)
      )(_.keyArn)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.KeyListEntry.ReadOnly =
    zio.aws.kms.model.KeyListEntry.wrap(buildAwsValue())
}
object KeyListEntry {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.kms.model.KeyListEntry] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.KeyListEntry = zio.aws.kms.model
      .KeyListEntry(keyId.map(value => value), keyArn.map(value => value))
    def keyId: Option[KeyIdType]
    def keyArn: Option[ArnType]
    def getKeyId: ZIO[Any, AwsError, KeyIdType] =
      AwsError.unwrapOptionField("keyId", keyId)
    def getKeyArn: ZIO[Any, AwsError, ArnType] =
      AwsError.unwrapOptionField("keyArn", keyArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.KeyListEntry
  ) extends zio.aws.kms.model.KeyListEntry.ReadOnly {
    override val keyId: Option[KeyIdType] = scala
      .Option(impl.keyId())
      .map(value => zio.aws.kms.model.primitives.KeyIdType(value))
    override val keyArn: Option[ArnType] = scala
      .Option(impl.keyArn())
      .map(value => zio.aws.kms.model.primitives.ArnType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.KeyListEntry
  ): zio.aws.kms.model.KeyListEntry.ReadOnly = new Wrapper(impl)
}
