package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{DateType, CiphertextType, KeyIdType}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class ImportKeyMaterialRequest(
    keyId: KeyIdType,
    importToken: CiphertextType,
    encryptedKeyMaterial: CiphertextType,
    validTo: Option[DateType] = None,
    expirationModel: Option[zio.aws.kms.model.ExpirationModelType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.ImportKeyMaterialRequest = {
    import ImportKeyMaterialRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.ImportKeyMaterialRequest
      .builder()
      .keyId(KeyIdType.unwrap(keyId): java.lang.String)
      .importToken(
        software.amazon.awssdk.core.SdkBytes
          .fromByteArrayUnsafe(importToken.toArray[Byte])
      )
      .encryptedKeyMaterial(
        software.amazon.awssdk.core.SdkBytes
          .fromByteArrayUnsafe(encryptedKeyMaterial.toArray[Byte])
      )
      .optionallyWith(validTo.map(value => DateType.unwrap(value): Instant))(
        _.validTo
      )
      .optionallyWith(expirationModel.map(value => value.unwrap))(
        _.expirationModel
      )
      .build()
  }
  def asReadOnly: zio.aws.kms.model.ImportKeyMaterialRequest.ReadOnly =
    zio.aws.kms.model.ImportKeyMaterialRequest.wrap(buildAwsValue())
}
object ImportKeyMaterialRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.ImportKeyMaterialRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.ImportKeyMaterialRequest =
      zio.aws.kms.model.ImportKeyMaterialRequest(
        keyId,
        importToken,
        encryptedKeyMaterial,
        validTo.map(value => value),
        expirationModel.map(value => value)
      )
    def keyId: KeyIdType
    def importToken: CiphertextType
    def encryptedKeyMaterial: CiphertextType
    def validTo: Option[DateType]
    def expirationModel: Option[zio.aws.kms.model.ExpirationModelType]
    def getKeyId: ZIO[Any, Nothing, KeyIdType] = ZIO.succeed(keyId)
    def getImportToken: ZIO[Any, Nothing, CiphertextType] =
      ZIO.succeed(importToken)
    def getEncryptedKeyMaterial: ZIO[Any, Nothing, CiphertextType] =
      ZIO.succeed(encryptedKeyMaterial)
    def getValidTo: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("validTo", validTo)
    def getExpirationModel
        : ZIO[Any, AwsError, zio.aws.kms.model.ExpirationModelType] =
      AwsError.unwrapOptionField("expirationModel", expirationModel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.ImportKeyMaterialRequest
  ) extends zio.aws.kms.model.ImportKeyMaterialRequest.ReadOnly {
    override val keyId: KeyIdType =
      zio.aws.kms.model.primitives.KeyIdType(impl.keyId())
    override val importToken: CiphertextType =
      zio.aws.kms.model.primitives.CiphertextType(
        zio.Chunk.fromArray(impl.importToken().asByteArrayUnsafe())
      )
    override val encryptedKeyMaterial: CiphertextType =
      zio.aws.kms.model.primitives.CiphertextType(
        zio.Chunk.fromArray(impl.encryptedKeyMaterial().asByteArrayUnsafe())
      )
    override val validTo: Option[DateType] = scala
      .Option(impl.validTo())
      .map(value => zio.aws.kms.model.primitives.DateType(value))
    override val expirationModel
        : Option[zio.aws.kms.model.ExpirationModelType] = scala
      .Option(impl.expirationModel())
      .map(value => zio.aws.kms.model.ExpirationModelType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.ImportKeyMaterialRequest
  ): zio.aws.kms.model.ImportKeyMaterialRequest.ReadOnly = new Wrapper(impl)
}
