package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{
  DateType,
  PlaintextType,
  CiphertextType,
  KeyIdType
}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class GetParametersForImportResponse(
    keyId: Option[KeyIdType] = None,
    importToken: Option[CiphertextType] = None,
    publicKey: Option[PlaintextType] = None,
    parametersValidTo: Option[DateType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.GetParametersForImportResponse = {
    import GetParametersForImportResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.GetParametersForImportResponse
      .builder()
      .optionallyWith(
        keyId.map(value => KeyIdType.unwrap(value): java.lang.String)
      )(_.keyId)
      .optionallyWith(
        importToken.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.importToken)
      .optionallyWith(
        publicKey.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.publicKey)
      .optionallyWith(
        parametersValidTo.map(value => DateType.unwrap(value): Instant)
      )(_.parametersValidTo)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.GetParametersForImportResponse.ReadOnly =
    zio.aws.kms.model.GetParametersForImportResponse.wrap(buildAwsValue())
}
object GetParametersForImportResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.GetParametersForImportResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.GetParametersForImportResponse =
      zio.aws.kms.model.GetParametersForImportResponse(
        keyId.map(value => value),
        importToken.map(value => value),
        publicKey.map(value => value),
        parametersValidTo.map(value => value)
      )
    def keyId: Option[KeyIdType]
    def importToken: Option[CiphertextType]
    def publicKey: Option[PlaintextType]
    def parametersValidTo: Option[DateType]
    def getKeyId: ZIO[Any, AwsError, KeyIdType] =
      AwsError.unwrapOptionField("keyId", keyId)
    def getImportToken: ZIO[Any, AwsError, CiphertextType] =
      AwsError.unwrapOptionField("importToken", importToken)
    def getPublicKey: ZIO[Any, AwsError, PlaintextType] =
      AwsError.unwrapOptionField("publicKey", publicKey)
    def getParametersValidTo: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("parametersValidTo", parametersValidTo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.GetParametersForImportResponse
  ) extends zio.aws.kms.model.GetParametersForImportResponse.ReadOnly {
    override val keyId: Option[KeyIdType] = scala
      .Option(impl.keyId())
      .map(value => zio.aws.kms.model.primitives.KeyIdType(value))
    override val importToken: Option[CiphertextType] = scala
      .Option(impl.importToken())
      .map(value =>
        zio.aws.kms.model.primitives
          .CiphertextType(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
    override val publicKey: Option[PlaintextType] = scala
      .Option(impl.publicKey())
      .map(value =>
        zio.aws.kms.model.primitives
          .PlaintextType(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
    override val parametersValidTo: Option[DateType] = scala
      .Option(impl.parametersValidTo())
      .map(value => zio.aws.kms.model.primitives.DateType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.GetParametersForImportResponse
  ): zio.aws.kms.model.GetParametersForImportResponse.ReadOnly = new Wrapper(
    impl
  )
}
