package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.PolicyType
import scala.jdk.CollectionConverters.*
final case class GetKeyPolicyResponse(policy: Option[PolicyType] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.GetKeyPolicyResponse = {
    import GetKeyPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.GetKeyPolicyResponse
      .builder()
      .optionallyWith(
        policy.map(value => PolicyType.unwrap(value): java.lang.String)
      )(_.policy)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.GetKeyPolicyResponse.ReadOnly =
    zio.aws.kms.model.GetKeyPolicyResponse.wrap(buildAwsValue())
}
object GetKeyPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.GetKeyPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.GetKeyPolicyResponse =
      zio.aws.kms.model.GetKeyPolicyResponse(policy.map(value => value))
    def policy: Option[PolicyType]
    def getPolicy: ZIO[Any, AwsError, PolicyType] =
      AwsError.unwrapOptionField("policy", policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.GetKeyPolicyResponse
  ) extends zio.aws.kms.model.GetKeyPolicyResponse.ReadOnly {
    override val policy: Option[PolicyType] = scala
      .Option(impl.policy())
      .map(value => zio.aws.kms.model.primitives.PolicyType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.GetKeyPolicyResponse
  ): zio.aws.kms.model.GetKeyPolicyResponse.ReadOnly = new Wrapper(impl)
}
