package zio.aws.kms.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{CustomKeyStoreIdType, NumberOfBytesType}
import scala.jdk.CollectionConverters.*
final case class GenerateRandomRequest(
    numberOfBytes: Option[NumberOfBytesType] = None,
    customKeyStoreId: Option[CustomKeyStoreIdType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.GenerateRandomRequest = {
    import GenerateRandomRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.GenerateRandomRequest
      .builder()
      .optionallyWith(
        numberOfBytes.map(value => NumberOfBytesType.unwrap(value): Integer)
      )(_.numberOfBytes)
      .optionallyWith(
        customKeyStoreId.map(value =>
          CustomKeyStoreIdType.unwrap(value): java.lang.String
        )
      )(_.customKeyStoreId)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.GenerateRandomRequest.ReadOnly =
    zio.aws.kms.model.GenerateRandomRequest.wrap(buildAwsValue())
}
object GenerateRandomRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.GenerateRandomRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.GenerateRandomRequest =
      zio.aws.kms.model.GenerateRandomRequest(
        numberOfBytes.map(value => value),
        customKeyStoreId.map(value => value)
      )
    def numberOfBytes: Option[NumberOfBytesType]
    def customKeyStoreId: Option[CustomKeyStoreIdType]
    def getNumberOfBytes: ZIO[Any, AwsError, NumberOfBytesType] =
      AwsError.unwrapOptionField("numberOfBytes", numberOfBytes)
    def getCustomKeyStoreId: ZIO[Any, AwsError, CustomKeyStoreIdType] =
      AwsError.unwrapOptionField("customKeyStoreId", customKeyStoreId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.GenerateRandomRequest
  ) extends zio.aws.kms.model.GenerateRandomRequest.ReadOnly {
    override val numberOfBytes: Option[NumberOfBytesType] = scala
      .Option(impl.numberOfBytes())
      .map(value => zio.aws.kms.model.primitives.NumberOfBytesType(value))
    override val customKeyStoreId: Option[CustomKeyStoreIdType] = scala
      .Option(impl.customKeyStoreId())
      .map(value => zio.aws.kms.model.primitives.CustomKeyStoreIdType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.GenerateRandomRequest
  ): zio.aws.kms.model.GenerateRandomRequest.ReadOnly = new Wrapper(impl)
}
