package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.kms.model.primitives.KeyIdType
import scala.jdk.CollectionConverters.*
final case class DisableKeyRotationRequest(keyId: KeyIdType) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.DisableKeyRotationRequest = {
    import DisableKeyRotationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.DisableKeyRotationRequest
      .builder()
      .keyId(KeyIdType.unwrap(keyId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.DisableKeyRotationRequest.ReadOnly =
    zio.aws.kms.model.DisableKeyRotationRequest.wrap(buildAwsValue())
}
object DisableKeyRotationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.DisableKeyRotationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.DisableKeyRotationRequest =
      zio.aws.kms.model.DisableKeyRotationRequest(keyId)
    def keyId: KeyIdType
    def getKeyId: ZIO[Any, Nothing, KeyIdType] = ZIO.succeed(keyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.DisableKeyRotationRequest
  ) extends zio.aws.kms.model.DisableKeyRotationRequest.ReadOnly {
    override val keyId: KeyIdType =
      zio.aws.kms.model.primitives.KeyIdType(impl.keyId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.DisableKeyRotationRequest
  ): zio.aws.kms.model.DisableKeyRotationRequest.ReadOnly = new Wrapper(impl)
}
