package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.kms.model.primitives.AliasNameType
import scala.jdk.CollectionConverters.*
final case class DeleteAliasRequest(aliasName: AliasNameType) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.DeleteAliasRequest = {
    import DeleteAliasRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.DeleteAliasRequest
      .builder()
      .aliasName(AliasNameType.unwrap(aliasName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.DeleteAliasRequest.ReadOnly =
    zio.aws.kms.model.DeleteAliasRequest.wrap(buildAwsValue())
}
object DeleteAliasRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.DeleteAliasRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.DeleteAliasRequest =
      zio.aws.kms.model.DeleteAliasRequest(aliasName)
    def aliasName: AliasNameType
    def getAliasName: ZIO[Any, Nothing, AliasNameType] = ZIO.succeed(aliasName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.DeleteAliasRequest
  ) extends zio.aws.kms.model.DeleteAliasRequest.ReadOnly {
    override val aliasName: AliasNameType =
      zio.aws.kms.model.primitives.AliasNameType(impl.aliasName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.DeleteAliasRequest
  ): zio.aws.kms.model.DeleteAliasRequest.ReadOnly = new Wrapper(impl)
}
