package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{
  DateType,
  TrustAnchorCertificateType,
  CustomKeyStoreNameType,
  CloudHsmClusterIdType,
  CustomKeyStoreIdType
}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class CustomKeyStoresListEntry(
    customKeyStoreId: Option[CustomKeyStoreIdType] = None,
    customKeyStoreName: Option[CustomKeyStoreNameType] = None,
    cloudHsmClusterId: Option[CloudHsmClusterIdType] = None,
    trustAnchorCertificate: Option[TrustAnchorCertificateType] = None,
    connectionState: Option[zio.aws.kms.model.ConnectionStateType] = None,
    connectionErrorCode: Option[zio.aws.kms.model.ConnectionErrorCodeType] =
      None,
    creationDate: Option[DateType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.CustomKeyStoresListEntry = {
    import CustomKeyStoresListEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.CustomKeyStoresListEntry
      .builder()
      .optionallyWith(
        customKeyStoreId.map(value =>
          CustomKeyStoreIdType.unwrap(value): java.lang.String
        )
      )(_.customKeyStoreId)
      .optionallyWith(
        customKeyStoreName.map(value =>
          CustomKeyStoreNameType.unwrap(value): java.lang.String
        )
      )(_.customKeyStoreName)
      .optionallyWith(
        cloudHsmClusterId.map(value =>
          CloudHsmClusterIdType.unwrap(value): java.lang.String
        )
      )(_.cloudHsmClusterId)
      .optionallyWith(
        trustAnchorCertificate.map(value =>
          TrustAnchorCertificateType.unwrap(value): java.lang.String
        )
      )(_.trustAnchorCertificate)
      .optionallyWith(connectionState.map(value => value.unwrap))(
        _.connectionState
      )
      .optionallyWith(connectionErrorCode.map(value => value.unwrap))(
        _.connectionErrorCode
      )
      .optionallyWith(
        creationDate.map(value => DateType.unwrap(value): Instant)
      )(_.creationDate)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.CustomKeyStoresListEntry.ReadOnly =
    zio.aws.kms.model.CustomKeyStoresListEntry.wrap(buildAwsValue())
}
object CustomKeyStoresListEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.CustomKeyStoresListEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.CustomKeyStoresListEntry =
      zio.aws.kms.model.CustomKeyStoresListEntry(
        customKeyStoreId.map(value => value),
        customKeyStoreName.map(value => value),
        cloudHsmClusterId.map(value => value),
        trustAnchorCertificate.map(value => value),
        connectionState.map(value => value),
        connectionErrorCode.map(value => value),
        creationDate.map(value => value)
      )
    def customKeyStoreId: Option[CustomKeyStoreIdType]
    def customKeyStoreName: Option[CustomKeyStoreNameType]
    def cloudHsmClusterId: Option[CloudHsmClusterIdType]
    def trustAnchorCertificate: Option[TrustAnchorCertificateType]
    def connectionState: Option[zio.aws.kms.model.ConnectionStateType]
    def connectionErrorCode: Option[zio.aws.kms.model.ConnectionErrorCodeType]
    def creationDate: Option[DateType]
    def getCustomKeyStoreId: ZIO[Any, AwsError, CustomKeyStoreIdType] =
      AwsError.unwrapOptionField("customKeyStoreId", customKeyStoreId)
    def getCustomKeyStoreName: ZIO[Any, AwsError, CustomKeyStoreNameType] =
      AwsError.unwrapOptionField("customKeyStoreName", customKeyStoreName)
    def getCloudHsmClusterId: ZIO[Any, AwsError, CloudHsmClusterIdType] =
      AwsError.unwrapOptionField("cloudHsmClusterId", cloudHsmClusterId)
    def getTrustAnchorCertificate
        : ZIO[Any, AwsError, TrustAnchorCertificateType] = AwsError
      .unwrapOptionField("trustAnchorCertificate", trustAnchorCertificate)
    def getConnectionState
        : ZIO[Any, AwsError, zio.aws.kms.model.ConnectionStateType] =
      AwsError.unwrapOptionField("connectionState", connectionState)
    def getConnectionErrorCode
        : ZIO[Any, AwsError, zio.aws.kms.model.ConnectionErrorCodeType] =
      AwsError.unwrapOptionField("connectionErrorCode", connectionErrorCode)
    def getCreationDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("creationDate", creationDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.CustomKeyStoresListEntry
  ) extends zio.aws.kms.model.CustomKeyStoresListEntry.ReadOnly {
    override val customKeyStoreId: Option[CustomKeyStoreIdType] = scala
      .Option(impl.customKeyStoreId())
      .map(value => zio.aws.kms.model.primitives.CustomKeyStoreIdType(value))
    override val customKeyStoreName: Option[CustomKeyStoreNameType] = scala
      .Option(impl.customKeyStoreName())
      .map(value => zio.aws.kms.model.primitives.CustomKeyStoreNameType(value))
    override val cloudHsmClusterId: Option[CloudHsmClusterIdType] = scala
      .Option(impl.cloudHsmClusterId())
      .map(value => zio.aws.kms.model.primitives.CloudHsmClusterIdType(value))
    override val trustAnchorCertificate: Option[TrustAnchorCertificateType] =
      scala
        .Option(impl.trustAnchorCertificate())
        .map(value =>
          zio.aws.kms.model.primitives.TrustAnchorCertificateType(value)
        )
    override val connectionState
        : Option[zio.aws.kms.model.ConnectionStateType] = scala
      .Option(impl.connectionState())
      .map(value => zio.aws.kms.model.ConnectionStateType.wrap(value))
    override val connectionErrorCode
        : Option[zio.aws.kms.model.ConnectionErrorCodeType] = scala
      .Option(impl.connectionErrorCode())
      .map(value => zio.aws.kms.model.ConnectionErrorCodeType.wrap(value))
    override val creationDate: Option[DateType] = scala
      .Option(impl.creationDate())
      .map(value => zio.aws.kms.model.primitives.DateType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.CustomKeyStoresListEntry
  ): zio.aws.kms.model.CustomKeyStoresListEntry.ReadOnly = new Wrapper(impl)
}
