package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{GrantIdType, GrantTokenType}
import scala.jdk.CollectionConverters.*
final case class CreateGrantResponse(
    grantToken: Option[GrantTokenType] = None,
    grantId: Option[GrantIdType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.CreateGrantResponse = {
    import CreateGrantResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.CreateGrantResponse
      .builder()
      .optionallyWith(
        grantToken.map(value => GrantTokenType.unwrap(value): java.lang.String)
      )(_.grantToken)
      .optionallyWith(
        grantId.map(value => GrantIdType.unwrap(value): java.lang.String)
      )(_.grantId)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.CreateGrantResponse.ReadOnly =
    zio.aws.kms.model.CreateGrantResponse.wrap(buildAwsValue())
}
object CreateGrantResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.CreateGrantResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.CreateGrantResponse =
      zio.aws.kms.model.CreateGrantResponse(
        grantToken.map(value => value),
        grantId.map(value => value)
      )
    def grantToken: Option[GrantTokenType]
    def grantId: Option[GrantIdType]
    def getGrantToken: ZIO[Any, AwsError, GrantTokenType] =
      AwsError.unwrapOptionField("grantToken", grantToken)
    def getGrantId: ZIO[Any, AwsError, GrantIdType] =
      AwsError.unwrapOptionField("grantId", grantId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.CreateGrantResponse
  ) extends zio.aws.kms.model.CreateGrantResponse.ReadOnly {
    override val grantToken: Option[GrantTokenType] = scala
      .Option(impl.grantToken())
      .map(value => zio.aws.kms.model.primitives.GrantTokenType(value))
    override val grantId: Option[GrantIdType] = scala
      .Option(impl.grantId())
      .map(value => zio.aws.kms.model.primitives.GrantIdType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.CreateGrantResponse
  ): zio.aws.kms.model.CreateGrantResponse.ReadOnly = new Wrapper(impl)
}
