package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.kms.model.primitives.{
  KeyStorePasswordType,
  TrustAnchorCertificateType,
  CloudHsmClusterIdType,
  CustomKeyStoreNameType
}
import scala.jdk.CollectionConverters.*
final case class CreateCustomKeyStoreRequest(
    customKeyStoreName: CustomKeyStoreNameType,
    cloudHsmClusterId: CloudHsmClusterIdType,
    trustAnchorCertificate: TrustAnchorCertificateType,
    keyStorePassword: KeyStorePasswordType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.CreateCustomKeyStoreRequest = {
    import CreateCustomKeyStoreRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.CreateCustomKeyStoreRequest
      .builder()
      .customKeyStoreName(
        CustomKeyStoreNameType.unwrap(customKeyStoreName): java.lang.String
      )
      .cloudHsmClusterId(
        CloudHsmClusterIdType.unwrap(cloudHsmClusterId): java.lang.String
      )
      .trustAnchorCertificate(
        TrustAnchorCertificateType.unwrap(
          trustAnchorCertificate
        ): java.lang.String
      )
      .keyStorePassword(
        KeyStorePasswordType.unwrap(keyStorePassword): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.kms.model.CreateCustomKeyStoreRequest.ReadOnly =
    zio.aws.kms.model.CreateCustomKeyStoreRequest.wrap(buildAwsValue())
}
object CreateCustomKeyStoreRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.CreateCustomKeyStoreRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.CreateCustomKeyStoreRequest =
      zio.aws.kms.model.CreateCustomKeyStoreRequest(
        customKeyStoreName,
        cloudHsmClusterId,
        trustAnchorCertificate,
        keyStorePassword
      )
    def customKeyStoreName: CustomKeyStoreNameType
    def cloudHsmClusterId: CloudHsmClusterIdType
    def trustAnchorCertificate: TrustAnchorCertificateType
    def keyStorePassword: KeyStorePasswordType
    def getCustomKeyStoreName: ZIO[Any, Nothing, CustomKeyStoreNameType] =
      ZIO.succeed(customKeyStoreName)
    def getCloudHsmClusterId: ZIO[Any, Nothing, CloudHsmClusterIdType] =
      ZIO.succeed(cloudHsmClusterId)
    def getTrustAnchorCertificate
        : ZIO[Any, Nothing, TrustAnchorCertificateType] =
      ZIO.succeed(trustAnchorCertificate)
    def getKeyStorePassword: ZIO[Any, Nothing, KeyStorePasswordType] =
      ZIO.succeed(keyStorePassword)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.CreateCustomKeyStoreRequest
  ) extends zio.aws.kms.model.CreateCustomKeyStoreRequest.ReadOnly {
    override val customKeyStoreName: CustomKeyStoreNameType =
      zio.aws.kms.model.primitives
        .CustomKeyStoreNameType(impl.customKeyStoreName())
    override val cloudHsmClusterId: CloudHsmClusterIdType =
      zio.aws.kms.model.primitives
        .CloudHsmClusterIdType(impl.cloudHsmClusterId())
    override val trustAnchorCertificate: TrustAnchorCertificateType =
      zio.aws.kms.model.primitives
        .TrustAnchorCertificateType(impl.trustAnchorCertificate())
    override val keyStorePassword: KeyStorePasswordType =
      zio.aws.kms.model.primitives.KeyStorePasswordType(impl.keyStorePassword())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.CreateCustomKeyStoreRequest
  ): zio.aws.kms.model.CreateCustomKeyStoreRequest.ReadOnly = new Wrapper(impl)
}
