package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.kms.model.primitives.CustomKeyStoreIdType
import scala.jdk.CollectionConverters.*
final case class ConnectCustomKeyStoreRequest(
    customKeyStoreId: CustomKeyStoreIdType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.ConnectCustomKeyStoreRequest = {
    import ConnectCustomKeyStoreRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.ConnectCustomKeyStoreRequest
      .builder()
      .customKeyStoreId(
        CustomKeyStoreIdType.unwrap(customKeyStoreId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.kms.model.ConnectCustomKeyStoreRequest.ReadOnly =
    zio.aws.kms.model.ConnectCustomKeyStoreRequest.wrap(buildAwsValue())
}
object ConnectCustomKeyStoreRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.ConnectCustomKeyStoreRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.ConnectCustomKeyStoreRequest =
      zio.aws.kms.model.ConnectCustomKeyStoreRequest(customKeyStoreId)
    def customKeyStoreId: CustomKeyStoreIdType
    def getCustomKeyStoreId: ZIO[Any, Nothing, CustomKeyStoreIdType] =
      ZIO.succeed(customKeyStoreId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.ConnectCustomKeyStoreRequest
  ) extends zio.aws.kms.model.ConnectCustomKeyStoreRequest.ReadOnly {
    override val customKeyStoreId: CustomKeyStoreIdType =
      zio.aws.kms.model.primitives.CustomKeyStoreIdType(impl.customKeyStoreId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.ConnectCustomKeyStoreRequest
  ): zio.aws.kms.model.ConnectCustomKeyStoreRequest.ReadOnly = new Wrapper(impl)
}
