package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{
  DateType,
  KeyIdType,
  ArnType,
  AliasNameType
}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class AliasListEntry(
    aliasName: Option[AliasNameType] = None,
    aliasArn: Option[ArnType] = None,
    targetKeyId: Option[KeyIdType] = None,
    creationDate: Option[DateType] = None,
    lastUpdatedDate: Option[DateType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.AliasListEntry = {
    import AliasListEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.AliasListEntry
      .builder()
      .optionallyWith(
        aliasName.map(value => AliasNameType.unwrap(value): java.lang.String)
      )(_.aliasName)
      .optionallyWith(
        aliasArn.map(value => ArnType.unwrap(value): java.lang.String)
      )(_.aliasArn)
      .optionallyWith(
        targetKeyId.map(value => KeyIdType.unwrap(value): java.lang.String)
      )(_.targetKeyId)
      .optionallyWith(
        creationDate.map(value => DateType.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        lastUpdatedDate.map(value => DateType.unwrap(value): Instant)
      )(_.lastUpdatedDate)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.AliasListEntry.ReadOnly =
    zio.aws.kms.model.AliasListEntry.wrap(buildAwsValue())
}
object AliasListEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.AliasListEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.AliasListEntry =
      zio.aws.kms.model.AliasListEntry(
        aliasName.map(value => value),
        aliasArn.map(value => value),
        targetKeyId.map(value => value),
        creationDate.map(value => value),
        lastUpdatedDate.map(value => value)
      )
    def aliasName: Option[AliasNameType]
    def aliasArn: Option[ArnType]
    def targetKeyId: Option[KeyIdType]
    def creationDate: Option[DateType]
    def lastUpdatedDate: Option[DateType]
    def getAliasName: ZIO[Any, AwsError, AliasNameType] =
      AwsError.unwrapOptionField("aliasName", aliasName)
    def getAliasArn: ZIO[Any, AwsError, ArnType] =
      AwsError.unwrapOptionField("aliasArn", aliasArn)
    def getTargetKeyId: ZIO[Any, AwsError, KeyIdType] =
      AwsError.unwrapOptionField("targetKeyId", targetKeyId)
    def getCreationDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getLastUpdatedDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("lastUpdatedDate", lastUpdatedDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.AliasListEntry
  ) extends zio.aws.kms.model.AliasListEntry.ReadOnly {
    override val aliasName: Option[AliasNameType] = scala
      .Option(impl.aliasName())
      .map(value => zio.aws.kms.model.primitives.AliasNameType(value))
    override val aliasArn: Option[ArnType] = scala
      .Option(impl.aliasArn())
      .map(value => zio.aws.kms.model.primitives.ArnType(value))
    override val targetKeyId: Option[KeyIdType] = scala
      .Option(impl.targetKeyId())
      .map(value => zio.aws.kms.model.primitives.KeyIdType(value))
    override val creationDate: Option[DateType] = scala
      .Option(impl.creationDate())
      .map(value => zio.aws.kms.model.primitives.DateType(value))
    override val lastUpdatedDate: Option[DateType] = scala
      .Option(impl.lastUpdatedDate())
      .map(value => zio.aws.kms.model.primitives.DateType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.AliasListEntry
  ): zio.aws.kms.model.AliasListEntry.ReadOnly = new Wrapper(impl)
}
