package zio.aws.kms
import zio.aws.kms.model.primitives.CustomKeyStoreNameType.Type
import java.time.Instant
import zio.aws.kms.model.primitives.{
  PolicyNameType,
  GrantTokenType,
  EncryptionContextValue,
  TagKeyType,
  EncryptionContextKey
}
import zio.Chunk
import zio.prelude.Subtype
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object AWSAccountIdType extends Subtype[String]
    type AWSAccountIdType = zio.aws.kms.model.primitives.AWSAccountIdType.Type
    object AliasNameType extends Subtype[String]
    type AliasNameType = zio.aws.kms.model.primitives.AliasNameType.Type
    object ArnType extends Subtype[String]
    type ArnType = zio.aws.kms.model.primitives.ArnType.Type
    object AttestationDocumentType extends Subtype[Chunk[Byte]]
    type AttestationDocumentType =
      zio.aws.kms.model.primitives.AttestationDocumentType.Type
    object BooleanType extends Subtype[Boolean]
    type BooleanType = zio.aws.kms.model.primitives.BooleanType.Type
    object CiphertextType extends Subtype[Chunk[Byte]]
    type CiphertextType = zio.aws.kms.model.primitives.CiphertextType.Type
    object CloudHsmClusterIdType extends Subtype[String]
    type CloudHsmClusterIdType =
      zio.aws.kms.model.primitives.CloudHsmClusterIdType.Type
    object CustomKeyStoreIdType extends Subtype[String]
    type CustomKeyStoreIdType =
      zio.aws.kms.model.primitives.CustomKeyStoreIdType.Type
    object CustomKeyStoreNameType extends Subtype[String]
    type CustomKeyStoreNameType =
      zio.aws.kms.model.primitives.CustomKeyStoreNameType.Type
    object DateType extends Subtype[Instant]
    type DateType = zio.aws.kms.model.primitives.DateType.Type
    object DescriptionType extends Subtype[String]
    type DescriptionType = zio.aws.kms.model.primitives.DescriptionType.Type
    object EncryptionContextKey extends Subtype[String]
    type EncryptionContextKey =
      zio.aws.kms.model.primitives.EncryptionContextKey.Type
    object EncryptionContextValue extends Subtype[String]
    type EncryptionContextValue =
      zio.aws.kms.model.primitives.EncryptionContextValue.Type
    object GrantIdType extends Subtype[String]
    type GrantIdType = zio.aws.kms.model.primitives.GrantIdType.Type
    object GrantNameType extends Subtype[String]
    type GrantNameType = zio.aws.kms.model.primitives.GrantNameType.Type
    object GrantTokenType extends Subtype[String]
    type GrantTokenType = zio.aws.kms.model.primitives.GrantTokenType.Type
    object KeyIdType extends Subtype[String]
    type KeyIdType = zio.aws.kms.model.primitives.KeyIdType.Type
    object KeyStorePasswordType extends Subtype[String]
    type KeyStorePasswordType =
      zio.aws.kms.model.primitives.KeyStorePasswordType.Type
    object LimitType extends Subtype[Int]
    type LimitType = zio.aws.kms.model.primitives.LimitType.Type
    object MarkerType extends Subtype[String]
    type MarkerType = zio.aws.kms.model.primitives.MarkerType.Type
    object NullableBooleanType extends Subtype[Boolean]
    type NullableBooleanType =
      zio.aws.kms.model.primitives.NullableBooleanType.Type
    object NumberOfBytesType extends Subtype[Int]
    type NumberOfBytesType = zio.aws.kms.model.primitives.NumberOfBytesType.Type
    object PendingWindowInDaysType extends Subtype[Int]
    type PendingWindowInDaysType =
      zio.aws.kms.model.primitives.PendingWindowInDaysType.Type
    object PlaintextType extends Subtype[Chunk[Byte]]
    type PlaintextType = zio.aws.kms.model.primitives.PlaintextType.Type
    object PolicyNameType extends Subtype[String]
    type PolicyNameType = zio.aws.kms.model.primitives.PolicyNameType.Type
    object PolicyType extends Subtype[String]
    type PolicyType = zio.aws.kms.model.primitives.PolicyType.Type
    object PrincipalIdType extends Subtype[String]
    type PrincipalIdType = zio.aws.kms.model.primitives.PrincipalIdType.Type
    object PublicKeyType extends Subtype[Chunk[Byte]]
    type PublicKeyType = zio.aws.kms.model.primitives.PublicKeyType.Type
    object RegionType extends Subtype[String]
    type RegionType = zio.aws.kms.model.primitives.RegionType.Type
    object TagKeyType extends Subtype[String]
    type TagKeyType = zio.aws.kms.model.primitives.TagKeyType.Type
    object TagValueType extends Subtype[String]
    type TagValueType = zio.aws.kms.model.primitives.TagValueType.Type
    object TrustAnchorCertificateType extends Subtype[String]
    type TrustAnchorCertificateType =
      zio.aws.kms.model.primitives.TrustAnchorCertificateType.Type
    object XksKeyIdType extends Subtype[String]
    type XksKeyIdType = zio.aws.kms.model.primitives.XksKeyIdType.Type
    object XksProxyAuthenticationAccessKeyIdType extends Subtype[String]
    type XksProxyAuthenticationAccessKeyIdType =
      zio.aws.kms.model.primitives.XksProxyAuthenticationAccessKeyIdType.Type
    object XksProxyAuthenticationRawSecretAccessKeyType extends Subtype[String]
    type XksProxyAuthenticationRawSecretAccessKeyType =
      zio.aws.kms.model.primitives.XksProxyAuthenticationRawSecretAccessKeyType.Type
    object XksProxyUriEndpointType extends Subtype[String]
    type XksProxyUriEndpointType =
      zio.aws.kms.model.primitives.XksProxyUriEndpointType.Type
    object XksProxyUriPathType extends Subtype[String]
    type XksProxyUriPathType =
      zio.aws.kms.model.primitives.XksProxyUriPathType.Type
    object XksProxyVpcEndpointServiceNameType extends Subtype[String]
    type XksProxyVpcEndpointServiceNameType =
      zio.aws.kms.model.primitives.XksProxyVpcEndpointServiceNameType.Type
  }
  type AliasList = List[zio.aws.kms.model.AliasListEntry]
  type CustomKeyStoresList = List[zio.aws.kms.model.CustomKeyStoresListEntry]
  type EncryptionAlgorithmSpecList =
    List[zio.aws.kms.model.EncryptionAlgorithmSpec]
  type EncryptionContextType = Map[EncryptionContextKey, EncryptionContextValue]
  type GrantList = List[zio.aws.kms.model.GrantListEntry]
  type GrantOperationList = List[zio.aws.kms.model.GrantOperation]
  type GrantTokenList = List[GrantTokenType]
  type KeyList = List[zio.aws.kms.model.KeyListEntry]
  type MacAlgorithmSpecList = List[zio.aws.kms.model.MacAlgorithmSpec]
  type MultiRegionKeyList = List[zio.aws.kms.model.MultiRegionKey]
  type PolicyNameList = List[PolicyNameType]
  type SigningAlgorithmSpecList = List[zio.aws.kms.model.SigningAlgorithmSpec]
  type TagKeyList = List[TagKeyType]
  type TagList = List[zio.aws.kms.model.Tag]
}
