package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.kms.model.primitives.{DescriptionType, KeyIdType}
import scala.jdk.CollectionConverters._
final case class UpdateKeyDescriptionRequest(
    keyId: KeyIdType,
    description: DescriptionType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.UpdateKeyDescriptionRequest = {
    import UpdateKeyDescriptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.UpdateKeyDescriptionRequest
      .builder()
      .keyId(KeyIdType.unwrap(keyId): java.lang.String)
      .description(DescriptionType.unwrap(description): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.UpdateKeyDescriptionRequest.ReadOnly =
    zio.aws.kms.model.UpdateKeyDescriptionRequest.wrap(buildAwsValue())
}
object UpdateKeyDescriptionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.UpdateKeyDescriptionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.UpdateKeyDescriptionRequest =
      zio.aws.kms.model.UpdateKeyDescriptionRequest(keyId, description)
    def keyId: KeyIdType
    def description: DescriptionType
    def getKeyId: ZIO[Any, Nothing, KeyIdType] = ZIO.succeed(keyId)
    def getDescription: ZIO[Any, Nothing, DescriptionType] =
      ZIO.succeed(description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.UpdateKeyDescriptionRequest
  ) extends zio.aws.kms.model.UpdateKeyDescriptionRequest.ReadOnly {
    override val keyId: KeyIdType =
      zio.aws.kms.model.primitives.KeyIdType(impl.keyId())
    override val description: DescriptionType =
      zio.aws.kms.model.primitives.DescriptionType(impl.description())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.UpdateKeyDescriptionRequest
  ): zio.aws.kms.model.UpdateKeyDescriptionRequest.ReadOnly = new Wrapper(impl)
}
