package zio.aws.kms.model
import zio.prelude.data.Optional
import zio.aws.kms.model.primitives.{
  GrantTokenType,
  KeyIdType,
  EncryptionContextValue,
  NumberOfBytesType,
  NullableBooleanType,
  EncryptionContextKey
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GenerateDataKeyWithoutPlaintextRequest(
    keyId: KeyIdType,
    encryptionContext: Optional[
      Map[EncryptionContextKey, EncryptionContextValue]
    ] = Optional.Absent,
    keySpec: Optional[zio.aws.kms.model.DataKeySpec] = Optional.Absent,
    numberOfBytes: Optional[NumberOfBytesType] = Optional.Absent,
    grantTokens: Optional[Iterable[GrantTokenType]] = Optional.Absent,
    dryRun: Optional[NullableBooleanType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.GenerateDataKeyWithoutPlaintextRequest = {
    import GenerateDataKeyWithoutPlaintextRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.GenerateDataKeyWithoutPlaintextRequest
      .builder()
      .keyId(KeyIdType.unwrap(keyId): java.lang.String)
      .optionallyWith(
        encryptionContext.map(value =>
          value
            .map({ case (key, value) =>
              (EncryptionContextKey.unwrap(
                key
              ): java.lang.String) -> (EncryptionContextValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.encryptionContext)
      .optionallyWith(keySpec.map(value => value.unwrap))(_.keySpec)
      .optionallyWith(
        numberOfBytes.map(value => NumberOfBytesType.unwrap(value): Integer)
      )(_.numberOfBytes)
      .optionallyWith(
        grantTokens.map(value =>
          value.map { item =>
            GrantTokenType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.grantTokens)
      .optionallyWith(
        dryRun.map(value =>
          NullableBooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.kms.model.GenerateDataKeyWithoutPlaintextRequest.ReadOnly =
    zio.aws.kms.model.GenerateDataKeyWithoutPlaintextRequest
      .wrap(buildAwsValue())
}
object GenerateDataKeyWithoutPlaintextRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.GenerateDataKeyWithoutPlaintextRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.GenerateDataKeyWithoutPlaintextRequest =
      zio.aws.kms.model.GenerateDataKeyWithoutPlaintextRequest(
        keyId,
        encryptionContext.map(value => value),
        keySpec.map(value => value),
        numberOfBytes.map(value => value),
        grantTokens.map(value => value),
        dryRun.map(value => value)
      )
    def keyId: KeyIdType
    def encryptionContext
        : Optional[Map[EncryptionContextKey, EncryptionContextValue]]
    def keySpec: Optional[zio.aws.kms.model.DataKeySpec]
    def numberOfBytes: Optional[NumberOfBytesType]
    def grantTokens: Optional[List[GrantTokenType]]
    def dryRun: Optional[NullableBooleanType]
    def getKeyId: ZIO[Any, Nothing, KeyIdType] = ZIO.succeed(keyId)
    def getEncryptionContext: ZIO[Any, AwsError, Map[
      EncryptionContextKey,
      EncryptionContextValue
    ]] = AwsError.unwrapOptionField("encryptionContext", encryptionContext)
    def getKeySpec: ZIO[Any, AwsError, zio.aws.kms.model.DataKeySpec] =
      AwsError.unwrapOptionField("keySpec", keySpec)
    def getNumberOfBytes: ZIO[Any, AwsError, NumberOfBytesType] =
      AwsError.unwrapOptionField("numberOfBytes", numberOfBytes)
    def getGrantTokens: ZIO[Any, AwsError, List[GrantTokenType]] =
      AwsError.unwrapOptionField("grantTokens", grantTokens)
    def getDryRun: ZIO[Any, AwsError, NullableBooleanType] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.GenerateDataKeyWithoutPlaintextRequest
  ) extends zio.aws.kms.model.GenerateDataKeyWithoutPlaintextRequest.ReadOnly {
    override val keyId: KeyIdType =
      zio.aws.kms.model.primitives.KeyIdType(impl.keyId())
    override val encryptionContext
        : Optional[Map[EncryptionContextKey, EncryptionContextValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionContext())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.kms.model.primitives.EncryptionContextKey(
                key
              ) -> zio.aws.kms.model.primitives.EncryptionContextValue(value)
            })
            .toMap
        )
    override val keySpec: Optional[zio.aws.kms.model.DataKeySpec] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keySpec())
        .map(value => zio.aws.kms.model.DataKeySpec.wrap(value))
    override val numberOfBytes: Optional[NumberOfBytesType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numberOfBytes())
        .map(value => zio.aws.kms.model.primitives.NumberOfBytesType(value))
    override val grantTokens: Optional[List[GrantTokenType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.grantTokens())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kms.model.primitives.GrantTokenType(item)
          }.toList
        )
    override val dryRun: Optional[NullableBooleanType] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => zio.aws.kms.model.primitives.NullableBooleanType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.GenerateDataKeyWithoutPlaintextRequest
  ): zio.aws.kms.model.GenerateDataKeyWithoutPlaintextRequest.ReadOnly =
    new Wrapper(impl)
}
