package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{
  TrustAnchorCertificateType,
  CustomKeyStoreNameType,
  CloudHsmClusterIdType,
  XksProxyVpcEndpointServiceNameType,
  XksProxyUriPathType,
  KeyStorePasswordType,
  XksProxyUriEndpointType
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateCustomKeyStoreRequest(
    customKeyStoreName: CustomKeyStoreNameType,
    cloudHsmClusterId: Optional[CloudHsmClusterIdType] = Optional.Absent,
    trustAnchorCertificate: Optional[TrustAnchorCertificateType] =
      Optional.Absent,
    keyStorePassword: Optional[KeyStorePasswordType] = Optional.Absent,
    customKeyStoreType: Optional[zio.aws.kms.model.CustomKeyStoreType] =
      Optional.Absent,
    xksProxyUriEndpoint: Optional[XksProxyUriEndpointType] = Optional.Absent,
    xksProxyUriPath: Optional[XksProxyUriPathType] = Optional.Absent,
    xksProxyVpcEndpointServiceName: Optional[
      XksProxyVpcEndpointServiceNameType
    ] = Optional.Absent,
    xksProxyAuthenticationCredential: Optional[
      zio.aws.kms.model.XksProxyAuthenticationCredentialType
    ] = Optional.Absent,
    xksProxyConnectivity: Optional[zio.aws.kms.model.XksProxyConnectivityType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.CreateCustomKeyStoreRequest = {
    import CreateCustomKeyStoreRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.CreateCustomKeyStoreRequest
      .builder()
      .customKeyStoreName(
        CustomKeyStoreNameType.unwrap(customKeyStoreName): java.lang.String
      )
      .optionallyWith(
        cloudHsmClusterId.map(value =>
          CloudHsmClusterIdType.unwrap(value): java.lang.String
        )
      )(_.cloudHsmClusterId)
      .optionallyWith(
        trustAnchorCertificate.map(value =>
          TrustAnchorCertificateType.unwrap(value): java.lang.String
        )
      )(_.trustAnchorCertificate)
      .optionallyWith(
        keyStorePassword.map(value =>
          KeyStorePasswordType.unwrap(value): java.lang.String
        )
      )(_.keyStorePassword)
      .optionallyWith(customKeyStoreType.map(value => value.unwrap))(
        _.customKeyStoreType
      )
      .optionallyWith(
        xksProxyUriEndpoint.map(value =>
          XksProxyUriEndpointType.unwrap(value): java.lang.String
        )
      )(_.xksProxyUriEndpoint)
      .optionallyWith(
        xksProxyUriPath.map(value =>
          XksProxyUriPathType.unwrap(value): java.lang.String
        )
      )(_.xksProxyUriPath)
      .optionallyWith(
        xksProxyVpcEndpointServiceName.map(value =>
          XksProxyVpcEndpointServiceNameType.unwrap(value): java.lang.String
        )
      )(_.xksProxyVpcEndpointServiceName)
      .optionallyWith(
        xksProxyAuthenticationCredential.map(value => value.buildAwsValue())
      )(_.xksProxyAuthenticationCredential)
      .optionallyWith(xksProxyConnectivity.map(value => value.unwrap))(
        _.xksProxyConnectivity
      )
      .build()
  }
  def asReadOnly: zio.aws.kms.model.CreateCustomKeyStoreRequest.ReadOnly =
    zio.aws.kms.model.CreateCustomKeyStoreRequest.wrap(buildAwsValue())
}
object CreateCustomKeyStoreRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.CreateCustomKeyStoreRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.CreateCustomKeyStoreRequest =
      zio.aws.kms.model.CreateCustomKeyStoreRequest(
        customKeyStoreName,
        cloudHsmClusterId.map(value => value),
        trustAnchorCertificate.map(value => value),
        keyStorePassword.map(value => value),
        customKeyStoreType.map(value => value),
        xksProxyUriEndpoint.map(value => value),
        xksProxyUriPath.map(value => value),
        xksProxyVpcEndpointServiceName.map(value => value),
        xksProxyAuthenticationCredential.map(value => value.asEditable),
        xksProxyConnectivity.map(value => value)
      )
    def customKeyStoreName: CustomKeyStoreNameType
    def cloudHsmClusterId: Optional[CloudHsmClusterIdType]
    def trustAnchorCertificate: Optional[TrustAnchorCertificateType]
    def keyStorePassword: Optional[KeyStorePasswordType]
    def customKeyStoreType: Optional[zio.aws.kms.model.CustomKeyStoreType]
    def xksProxyUriEndpoint: Optional[XksProxyUriEndpointType]
    def xksProxyUriPath: Optional[XksProxyUriPathType]
    def xksProxyVpcEndpointServiceName
        : Optional[XksProxyVpcEndpointServiceNameType]
    def xksProxyAuthenticationCredential: Optional[
      zio.aws.kms.model.XksProxyAuthenticationCredentialType.ReadOnly
    ]
    def xksProxyConnectivity
        : Optional[zio.aws.kms.model.XksProxyConnectivityType]
    def getCustomKeyStoreName: ZIO[Any, Nothing, CustomKeyStoreNameType] =
      ZIO.succeed(customKeyStoreName)
    def getCloudHsmClusterId: ZIO[Any, AwsError, CloudHsmClusterIdType] =
      AwsError.unwrapOptionField("cloudHsmClusterId", cloudHsmClusterId)
    def getTrustAnchorCertificate
        : ZIO[Any, AwsError, TrustAnchorCertificateType] = AwsError
      .unwrapOptionField("trustAnchorCertificate", trustAnchorCertificate)
    def getKeyStorePassword: ZIO[Any, AwsError, KeyStorePasswordType] =
      AwsError.unwrapOptionField("keyStorePassword", keyStorePassword)
    def getCustomKeyStoreType
        : ZIO[Any, AwsError, zio.aws.kms.model.CustomKeyStoreType] =
      AwsError.unwrapOptionField("customKeyStoreType", customKeyStoreType)
    def getXksProxyUriEndpoint: ZIO[Any, AwsError, XksProxyUriEndpointType] =
      AwsError.unwrapOptionField("xksProxyUriEndpoint", xksProxyUriEndpoint)
    def getXksProxyUriPath: ZIO[Any, AwsError, XksProxyUriPathType] =
      AwsError.unwrapOptionField("xksProxyUriPath", xksProxyUriPath)
    def getXksProxyVpcEndpointServiceName
        : ZIO[Any, AwsError, XksProxyVpcEndpointServiceNameType] =
      AwsError.unwrapOptionField(
        "xksProxyVpcEndpointServiceName",
        xksProxyVpcEndpointServiceName
      )
    def getXksProxyAuthenticationCredential: ZIO[
      Any,
      AwsError,
      zio.aws.kms.model.XksProxyAuthenticationCredentialType.ReadOnly
    ] = AwsError.unwrapOptionField(
      "xksProxyAuthenticationCredential",
      xksProxyAuthenticationCredential
    )
    def getXksProxyConnectivity
        : ZIO[Any, AwsError, zio.aws.kms.model.XksProxyConnectivityType] =
      AwsError.unwrapOptionField("xksProxyConnectivity", xksProxyConnectivity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.CreateCustomKeyStoreRequest
  ) extends zio.aws.kms.model.CreateCustomKeyStoreRequest.ReadOnly {
    override val customKeyStoreName: CustomKeyStoreNameType =
      zio.aws.kms.model.primitives
        .CustomKeyStoreNameType(impl.customKeyStoreName())
    override val cloudHsmClusterId: Optional[CloudHsmClusterIdType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudHsmClusterId())
        .map(value => zio.aws.kms.model.primitives.CloudHsmClusterIdType(value))
    override val trustAnchorCertificate: Optional[TrustAnchorCertificateType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trustAnchorCertificate())
        .map(value =>
          zio.aws.kms.model.primitives.TrustAnchorCertificateType(value)
        )
    override val keyStorePassword: Optional[KeyStorePasswordType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keyStorePassword())
        .map(value => zio.aws.kms.model.primitives.KeyStorePasswordType(value))
    override val customKeyStoreType
        : Optional[zio.aws.kms.model.CustomKeyStoreType] = zio.aws.core.internal
      .optionalFromNullable(impl.customKeyStoreType())
      .map(value => zio.aws.kms.model.CustomKeyStoreType.wrap(value))
    override val xksProxyUriEndpoint: Optional[XksProxyUriEndpointType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.xksProxyUriEndpoint())
        .map(value =>
          zio.aws.kms.model.primitives.XksProxyUriEndpointType(value)
        )
    override val xksProxyUriPath: Optional[XksProxyUriPathType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.xksProxyUriPath())
        .map(value => zio.aws.kms.model.primitives.XksProxyUriPathType(value))
    override val xksProxyVpcEndpointServiceName
        : Optional[XksProxyVpcEndpointServiceNameType] = zio.aws.core.internal
      .optionalFromNullable(impl.xksProxyVpcEndpointServiceName())
      .map(value =>
        zio.aws.kms.model.primitives.XksProxyVpcEndpointServiceNameType(value)
      )
    override val xksProxyAuthenticationCredential: Optional[
      zio.aws.kms.model.XksProxyAuthenticationCredentialType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.xksProxyAuthenticationCredential())
      .map(value =>
        zio.aws.kms.model.XksProxyAuthenticationCredentialType.wrap(value)
      )
    override val xksProxyConnectivity
        : Optional[zio.aws.kms.model.XksProxyConnectivityType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.xksProxyConnectivity())
        .map(value => zio.aws.kms.model.XksProxyConnectivityType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.CreateCustomKeyStoreRequest
  ): zio.aws.kms.model.CreateCustomKeyStoreRequest.ReadOnly = new Wrapper(impl)
}
