package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{
  GrantTokenType,
  KeyIdType,
  CiphertextType,
  EncryptionContextValue,
  NullableBooleanType,
  EncryptionContextKey
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ReEncryptRequest(
    ciphertextBlob: CiphertextType,
    sourceEncryptionContext: Optional[
      Map[EncryptionContextKey, EncryptionContextValue]
    ] = Optional.Absent,
    sourceKeyId: Optional[KeyIdType] = Optional.Absent,
    destinationKeyId: KeyIdType,
    destinationEncryptionContext: Optional[
      Map[EncryptionContextKey, EncryptionContextValue]
    ] = Optional.Absent,
    sourceEncryptionAlgorithm: Optional[
      zio.aws.kms.model.EncryptionAlgorithmSpec
    ] = Optional.Absent,
    destinationEncryptionAlgorithm: Optional[
      zio.aws.kms.model.EncryptionAlgorithmSpec
    ] = Optional.Absent,
    grantTokens: Optional[Iterable[GrantTokenType]] = Optional.Absent,
    dryRun: Optional[NullableBooleanType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.ReEncryptRequest = {
    import ReEncryptRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.ReEncryptRequest
      .builder()
      .ciphertextBlob(
        software.amazon.awssdk.core.SdkBytes.fromByteArrayUnsafe(
          ciphertextBlob.toArray[Byte]
        )
      )
      .optionallyWith(
        sourceEncryptionContext.map(value =>
          value
            .map({ case (key, value) =>
              (EncryptionContextKey.unwrap(
                key
              ): java.lang.String) -> (EncryptionContextValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.sourceEncryptionContext)
      .optionallyWith(
        sourceKeyId.map(value => KeyIdType.unwrap(value): java.lang.String)
      )(_.sourceKeyId)
      .destinationKeyId(KeyIdType.unwrap(destinationKeyId): java.lang.String)
      .optionallyWith(
        destinationEncryptionContext.map(value =>
          value
            .map({ case (key, value) =>
              (EncryptionContextKey.unwrap(
                key
              ): java.lang.String) -> (EncryptionContextValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.destinationEncryptionContext)
      .optionallyWith(sourceEncryptionAlgorithm.map(value => value.unwrap))(
        _.sourceEncryptionAlgorithm
      )
      .optionallyWith(
        destinationEncryptionAlgorithm.map(value => value.unwrap)
      )(_.destinationEncryptionAlgorithm)
      .optionallyWith(
        grantTokens.map(value =>
          value.map { item =>
            GrantTokenType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.grantTokens)
      .optionallyWith(
        dryRun.map(value =>
          NullableBooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.ReEncryptRequest.ReadOnly =
    zio.aws.kms.model.ReEncryptRequest.wrap(buildAwsValue())
}
object ReEncryptRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.ReEncryptRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.ReEncryptRequest =
      zio.aws.kms.model.ReEncryptRequest(
        ciphertextBlob,
        sourceEncryptionContext.map(value => value),
        sourceKeyId.map(value => value),
        destinationKeyId,
        destinationEncryptionContext.map(value => value),
        sourceEncryptionAlgorithm.map(value => value),
        destinationEncryptionAlgorithm.map(value => value),
        grantTokens.map(value => value),
        dryRun.map(value => value)
      )
    def ciphertextBlob: CiphertextType
    def sourceEncryptionContext
        : Optional[Map[EncryptionContextKey, EncryptionContextValue]]
    def sourceKeyId: Optional[KeyIdType]
    def destinationKeyId: KeyIdType
    def destinationEncryptionContext
        : Optional[Map[EncryptionContextKey, EncryptionContextValue]]
    def sourceEncryptionAlgorithm
        : Optional[zio.aws.kms.model.EncryptionAlgorithmSpec]
    def destinationEncryptionAlgorithm
        : Optional[zio.aws.kms.model.EncryptionAlgorithmSpec]
    def grantTokens: Optional[List[GrantTokenType]]
    def dryRun: Optional[NullableBooleanType]
    def getCiphertextBlob: ZIO[Any, Nothing, CiphertextType] =
      ZIO.succeed(ciphertextBlob)
    def getSourceEncryptionContext: ZIO[Any, AwsError, Map[
      EncryptionContextKey,
      EncryptionContextValue
    ]] = AwsError.unwrapOptionField(
      "sourceEncryptionContext",
      sourceEncryptionContext
    )
    def getSourceKeyId: ZIO[Any, AwsError, KeyIdType] =
      AwsError.unwrapOptionField("sourceKeyId", sourceKeyId)
    def getDestinationKeyId: ZIO[Any, Nothing, KeyIdType] =
      ZIO.succeed(destinationKeyId)
    def getDestinationEncryptionContext: ZIO[Any, AwsError, Map[
      EncryptionContextKey,
      EncryptionContextValue
    ]] = AwsError.unwrapOptionField(
      "destinationEncryptionContext",
      destinationEncryptionContext
    )
    def getSourceEncryptionAlgorithm
        : ZIO[Any, AwsError, zio.aws.kms.model.EncryptionAlgorithmSpec] =
      AwsError.unwrapOptionField(
        "sourceEncryptionAlgorithm",
        sourceEncryptionAlgorithm
      )
    def getDestinationEncryptionAlgorithm
        : ZIO[Any, AwsError, zio.aws.kms.model.EncryptionAlgorithmSpec] =
      AwsError.unwrapOptionField(
        "destinationEncryptionAlgorithm",
        destinationEncryptionAlgorithm
      )
    def getGrantTokens: ZIO[Any, AwsError, List[GrantTokenType]] =
      AwsError.unwrapOptionField("grantTokens", grantTokens)
    def getDryRun: ZIO[Any, AwsError, NullableBooleanType] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.ReEncryptRequest
  ) extends zio.aws.kms.model.ReEncryptRequest.ReadOnly {
    override val ciphertextBlob: CiphertextType =
      zio.aws.kms.model.primitives.CiphertextType(
        zio.Chunk.fromArray(impl.ciphertextBlob().asByteArrayUnsafe())
      )
    override val sourceEncryptionContext
        : Optional[Map[EncryptionContextKey, EncryptionContextValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceEncryptionContext())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.kms.model.primitives.EncryptionContextKey(
                key
              ) -> zio.aws.kms.model.primitives.EncryptionContextValue(value)
            })
            .toMap
        )
    override val sourceKeyId: Optional[KeyIdType] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceKeyId())
      .map(value => zio.aws.kms.model.primitives.KeyIdType(value))
    override val destinationKeyId: KeyIdType =
      zio.aws.kms.model.primitives.KeyIdType(impl.destinationKeyId())
    override val destinationEncryptionContext
        : Optional[Map[EncryptionContextKey, EncryptionContextValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationEncryptionContext())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.kms.model.primitives.EncryptionContextKey(
                key
              ) -> zio.aws.kms.model.primitives.EncryptionContextValue(value)
            })
            .toMap
        )
    override val sourceEncryptionAlgorithm
        : Optional[zio.aws.kms.model.EncryptionAlgorithmSpec] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceEncryptionAlgorithm())
        .map(value => zio.aws.kms.model.EncryptionAlgorithmSpec.wrap(value))
    override val destinationEncryptionAlgorithm
        : Optional[zio.aws.kms.model.EncryptionAlgorithmSpec] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationEncryptionAlgorithm())
        .map(value => zio.aws.kms.model.EncryptionAlgorithmSpec.wrap(value))
    override val grantTokens: Optional[List[GrantTokenType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.grantTokens())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kms.model.primitives.GrantTokenType(item)
          }.toList
        )
    override val dryRun: Optional[NullableBooleanType] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => zio.aws.kms.model.primitives.NullableBooleanType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.ReEncryptRequest
  ): zio.aws.kms.model.ReEncryptRequest.ReadOnly = new Wrapper(impl)
}
