package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{
  GrantTokenType,
  KeyIdType,
  EncryptionContextValue,
  NullableBooleanType,
  EncryptionContextKey
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GenerateDataKeyPairRequest(
    encryptionContext: Optional[
      Map[EncryptionContextKey, EncryptionContextValue]
    ] = Optional.Absent,
    keyId: KeyIdType,
    keyPairSpec: zio.aws.kms.model.DataKeyPairSpec,
    grantTokens: Optional[Iterable[GrantTokenType]] = Optional.Absent,
    recipient: Optional[zio.aws.kms.model.RecipientInfo] = Optional.Absent,
    dryRun: Optional[NullableBooleanType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.GenerateDataKeyPairRequest = {
    import GenerateDataKeyPairRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.GenerateDataKeyPairRequest
      .builder()
      .optionallyWith(
        encryptionContext.map(value =>
          value
            .map({ case (key, value) =>
              (EncryptionContextKey.unwrap(
                key
              ): java.lang.String) -> (EncryptionContextValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.encryptionContext)
      .keyId(KeyIdType.unwrap(keyId): java.lang.String)
      .keyPairSpec(keyPairSpec.unwrap)
      .optionallyWith(
        grantTokens.map(value =>
          value.map { item =>
            GrantTokenType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.grantTokens)
      .optionallyWith(recipient.map(value => value.buildAwsValue()))(
        _.recipient
      )
      .optionallyWith(
        dryRun.map(value =>
          NullableBooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.GenerateDataKeyPairRequest.ReadOnly =
    zio.aws.kms.model.GenerateDataKeyPairRequest.wrap(buildAwsValue())
}
object GenerateDataKeyPairRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.GenerateDataKeyPairRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.GenerateDataKeyPairRequest =
      zio.aws.kms.model.GenerateDataKeyPairRequest(
        encryptionContext.map(value => value),
        keyId,
        keyPairSpec,
        grantTokens.map(value => value),
        recipient.map(value => value.asEditable),
        dryRun.map(value => value)
      )
    def encryptionContext
        : Optional[Map[EncryptionContextKey, EncryptionContextValue]]
    def keyId: KeyIdType
    def keyPairSpec: zio.aws.kms.model.DataKeyPairSpec
    def grantTokens: Optional[List[GrantTokenType]]
    def recipient: Optional[zio.aws.kms.model.RecipientInfo.ReadOnly]
    def dryRun: Optional[NullableBooleanType]
    def getEncryptionContext: ZIO[Any, AwsError, Map[
      EncryptionContextKey,
      EncryptionContextValue
    ]] = AwsError.unwrapOptionField("encryptionContext", encryptionContext)
    def getKeyId: ZIO[Any, Nothing, KeyIdType] = ZIO.succeed(keyId)
    def getKeyPairSpec: ZIO[Any, Nothing, zio.aws.kms.model.DataKeyPairSpec] =
      ZIO.succeed(keyPairSpec)
    def getGrantTokens: ZIO[Any, AwsError, List[GrantTokenType]] =
      AwsError.unwrapOptionField("grantTokens", grantTokens)
    def getRecipient
        : ZIO[Any, AwsError, zio.aws.kms.model.RecipientInfo.ReadOnly] =
      AwsError.unwrapOptionField("recipient", recipient)
    def getDryRun: ZIO[Any, AwsError, NullableBooleanType] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.GenerateDataKeyPairRequest
  ) extends zio.aws.kms.model.GenerateDataKeyPairRequest.ReadOnly {
    override val encryptionContext
        : Optional[Map[EncryptionContextKey, EncryptionContextValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionContext())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.kms.model.primitives.EncryptionContextKey(
                key
              ) -> zio.aws.kms.model.primitives.EncryptionContextValue(value)
            })
            .toMap
        )
    override val keyId: KeyIdType =
      zio.aws.kms.model.primitives.KeyIdType(impl.keyId())
    override val keyPairSpec: zio.aws.kms.model.DataKeyPairSpec =
      zio.aws.kms.model.DataKeyPairSpec.wrap(impl.keyPairSpec())
    override val grantTokens: Optional[List[GrantTokenType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.grantTokens())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kms.model.primitives.GrantTokenType(item)
          }.toList
        )
    override val recipient: Optional[zio.aws.kms.model.RecipientInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recipient())
        .map(value => zio.aws.kms.model.RecipientInfo.wrap(value))
    override val dryRun: Optional[NullableBooleanType] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => zio.aws.kms.model.primitives.NullableBooleanType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.GenerateDataKeyPairRequest
  ): zio.aws.kms.model.GenerateDataKeyPairRequest.ReadOnly = new Wrapper(impl)
}
