package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{
  GrantTokenType,
  KeyIdType,
  EncryptionContextValue,
  PlaintextType,
  NullableBooleanType,
  EncryptionContextKey
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EncryptRequest(
    keyId: KeyIdType,
    plaintext: PlaintextType,
    encryptionContext: Optional[
      Map[EncryptionContextKey, EncryptionContextValue]
    ] = Optional.Absent,
    grantTokens: Optional[Iterable[GrantTokenType]] = Optional.Absent,
    encryptionAlgorithm: Optional[zio.aws.kms.model.EncryptionAlgorithmSpec] =
      Optional.Absent,
    dryRun: Optional[NullableBooleanType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.EncryptRequest = {
    import EncryptRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.EncryptRequest
      .builder()
      .keyId(KeyIdType.unwrap(keyId): java.lang.String)
      .plaintext(
        software.amazon.awssdk.core.SdkBytes.fromByteArrayUnsafe(
          plaintext.toArray[Byte]
        )
      )
      .optionallyWith(
        encryptionContext.map(value =>
          value
            .map({ case (key, value) =>
              (EncryptionContextKey.unwrap(
                key
              ): java.lang.String) -> (EncryptionContextValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.encryptionContext)
      .optionallyWith(
        grantTokens.map(value =>
          value.map { item =>
            GrantTokenType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.grantTokens)
      .optionallyWith(encryptionAlgorithm.map(value => value.unwrap))(
        _.encryptionAlgorithm
      )
      .optionallyWith(
        dryRun.map(value =>
          NullableBooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.EncryptRequest.ReadOnly =
    zio.aws.kms.model.EncryptRequest.wrap(buildAwsValue())
}
object EncryptRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.EncryptRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.EncryptRequest =
      zio.aws.kms.model.EncryptRequest(
        keyId,
        plaintext,
        encryptionContext.map(value => value),
        grantTokens.map(value => value),
        encryptionAlgorithm.map(value => value),
        dryRun.map(value => value)
      )
    def keyId: KeyIdType
    def plaintext: PlaintextType
    def encryptionContext
        : Optional[Map[EncryptionContextKey, EncryptionContextValue]]
    def grantTokens: Optional[List[GrantTokenType]]
    def encryptionAlgorithm: Optional[zio.aws.kms.model.EncryptionAlgorithmSpec]
    def dryRun: Optional[NullableBooleanType]
    def getKeyId: ZIO[Any, Nothing, KeyIdType] = ZIO.succeed(keyId)
    def getPlaintext: ZIO[Any, Nothing, PlaintextType] = ZIO.succeed(plaintext)
    def getEncryptionContext: ZIO[Any, AwsError, Map[
      EncryptionContextKey,
      EncryptionContextValue
    ]] = AwsError.unwrapOptionField("encryptionContext", encryptionContext)
    def getGrantTokens: ZIO[Any, AwsError, List[GrantTokenType]] =
      AwsError.unwrapOptionField("grantTokens", grantTokens)
    def getEncryptionAlgorithm
        : ZIO[Any, AwsError, zio.aws.kms.model.EncryptionAlgorithmSpec] =
      AwsError.unwrapOptionField("encryptionAlgorithm", encryptionAlgorithm)
    def getDryRun: ZIO[Any, AwsError, NullableBooleanType] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.EncryptRequest
  ) extends zio.aws.kms.model.EncryptRequest.ReadOnly {
    override val keyId: KeyIdType =
      zio.aws.kms.model.primitives.KeyIdType(impl.keyId())
    override val plaintext: PlaintextType = zio.aws.kms.model.primitives
      .PlaintextType(zio.Chunk.fromArray(impl.plaintext().asByteArrayUnsafe()))
    override val encryptionContext
        : Optional[Map[EncryptionContextKey, EncryptionContextValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionContext())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.kms.model.primitives.EncryptionContextKey(
                key
              ) -> zio.aws.kms.model.primitives.EncryptionContextValue(value)
            })
            .toMap
        )
    override val grantTokens: Optional[List[GrantTokenType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.grantTokens())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kms.model.primitives.GrantTokenType(item)
          }.toList
        )
    override val encryptionAlgorithm
        : Optional[zio.aws.kms.model.EncryptionAlgorithmSpec] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionAlgorithm())
        .map(value => zio.aws.kms.model.EncryptionAlgorithmSpec.wrap(value))
    override val dryRun: Optional[NullableBooleanType] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => zio.aws.kms.model.primitives.NullableBooleanType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.EncryptRequest
  ): zio.aws.kms.model.EncryptRequest.ReadOnly = new Wrapper(impl)
}
